/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.service.utils;

import com.flipkart.grayskull.spi.EncryptionService;
import com.flipkart.grayskull.spi.models.SecretData;
import java.util.Base64;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class SecretEncryptionUtil {
    private final EncryptionService encryptionService;

    public void encryptSecretData(SecretData secretData, String keyId) {
        if (secretData.getPrivatePart() != null && !secretData.getPrivatePart().isEmpty()) {
            byte[] encrypted = this.encryptionService.encrypt(secretData.getPrivatePart().getBytes(), keyId);
            secretData.setPrivatePart(Base64.getEncoder().encodeToString(encrypted));
            secretData.setKmsKeyId(keyId);
        }
    }

    public void decryptSecretData(SecretData secretData) {
        if (secretData.getPrivatePart() != null && !secretData.getPrivatePart().isEmpty()) {
            byte[] decrypted = this.encryptionService.decrypt(Base64.getDecoder().decode(secretData.getPrivatePart()), secretData.getKmsKeyId());
            secretData.setPrivatePart(new String(decrypted));
        }
    }

    @Generated
    public SecretEncryptionUtil(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

