/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.mappers;

import com.flipkart.grayskull.entities.SecretDataEntity;
import com.flipkart.grayskull.entities.SecretEntity;
import com.flipkart.grayskull.models.dto.request.CreateSecretRequest;
import com.flipkart.grayskull.models.dto.request.UpgradeSecretDataRequest;
import com.flipkart.grayskull.models.dto.response.SecretDataResponse;
import com.flipkart.grayskull.models.dto.response.SecretDataVersionResponse;
import com.flipkart.grayskull.models.dto.response.SecretMetadata;
import com.flipkart.grayskull.models.dto.response.SecretResponse;
import com.flipkart.grayskull.spi.models.Secret;
import com.flipkart.grayskull.spi.models.SecretData;
import com.flipkart.grayskull.spi.models.enums.LifecycleState;
import java.util.UUID;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(componentModel="spring", unmappedTargetPolicy=ReportingPolicy.IGNORE, imports={UUID.class, LifecycleState.class})
public interface SecretMapper {
    default public SecretEntity requestToSecret(CreateSecretRequest request, String projectId, String systemUser) {
        return ((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)((SecretEntity.SecretEntityBuilder)SecretEntity.builder().id(UUID.randomUUID().toString())).projectId(projectId)).name(request.getName())).systemLabels(null)).currentDataVersion(1)).lastRotated(null)).state(LifecycleState.ACTIVE)).provider(request.getProvider() != null ? request.getProvider().name() : null)).providerMeta(request.getProviderMeta())).metadataVersion(1)).version(null)).createdBy(systemUser)).updatedBy(systemUser)).data(null)).build();
    }

    @Mappings(value={@Mapping(target="id", expression="java(UUID.randomUUID().toString())"), @Mapping(target="privatePart", source="request.data.privatePart"), @Mapping(target="publicPart", source="request.data.publicPart"), @Mapping(target="dataVersion", constant="1L"), @Mapping(target="secretId", source="secretId")})
    public SecretDataEntity requestToSecretData(CreateSecretRequest var1, String var2);

    @Mappings(value={@Mapping(target="id", expression="java(UUID.randomUUID().toString())"), @Mapping(target="secretId", source="secret.id"), @Mapping(target="dataVersion", source="newVersion")})
    public SecretDataEntity upgradeRequestToSecretData(UpgradeSecretDataRequest var1, Secret var2, int var3);

    public SecretMetadata secretToSecretMetadata(Secret var1);

    public SecretResponse secretToSecretResponse(Secret var1);

    @Mappings(value={@Mapping(target="dataVersion", source="secretData.dataVersion"), @Mapping(target="publicPart", source="secretData.publicPart"), @Mapping(target="privatePart", source="secretData.privatePart"), @Mapping(target="state", source="secret.state"), @Mapping(target="lastRotated", source="secret.lastRotated"), @Mapping(target="creationTime", source="secret.creationTime"), @Mapping(target="updatedTime", source="secret.updatedTime"), @Mapping(target="createdBy", source="secret.createdBy"), @Mapping(target="updatedBy", source="secret.updatedBy")})
    public SecretDataResponse toSecretDataResponse(Secret var1, SecretData var2);

    @InheritConfiguration(name="toSecretDataResponse")
    @Mapping(target="state", source="secret.state")
    public SecretDataVersionResponse secretDataToSecretDataVersionResponse(Secret var1, SecretData var2);

    default public String lifecycleStateToString(LifecycleState state) {
        return state == null ? null : state.name();
    }
}

