/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.filters;

import com.flipkart.grayskull.spi.GrayskullAuthenticationProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthenticationFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    private final GrayskullAuthenticationProvider authenticationProvider;
    private final AuthenticationEntryPoint authenticationEntryPoint;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            Authentication authentication = this.authenticationProvider.authenticate(request);
            if (authentication != null) {
                SecurityContext context = SecurityContextHolder.getContextHolderStrategy().createEmptyContext();
                context.setAuthentication(authentication);
                SecurityContextHolder.setContext((SecurityContext)context);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (AuthenticationException e) {
            SecurityContextHolder.clearContext();
            log.debug("Failed to process authentication request", (Throwable)e);
            this.authenticationEntryPoint.commence(request, response, e);
        }
    }

    @Generated
    public AuthenticationFilter(GrayskullAuthenticationProvider authenticationProvider, AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationProvider = authenticationProvider;
        this.authenticationEntryPoint = authenticationEntryPoint;
    }
}

