/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.controllers;

import com.flipkart.grayskull.audit.AuditAction;
import com.flipkart.grayskull.audit.utils.RequestUtils;
import com.flipkart.grayskull.models.dto.request.CreateSecretRequest;
import com.flipkart.grayskull.models.dto.request.UpgradeSecretDataRequest;
import com.flipkart.grayskull.models.dto.response.ListSecretsResponse;
import com.flipkart.grayskull.models.dto.response.ResponseTemplate;
import com.flipkart.grayskull.models.dto.response.SecretDataResponse;
import com.flipkart.grayskull.models.dto.response.SecretDataVersionResponse;
import com.flipkart.grayskull.models.dto.response.SecretMetadata;
import com.flipkart.grayskull.models.dto.response.SecretResponse;
import com.flipkart.grayskull.models.dto.response.UpgradeSecretDataResponse;
import com.flipkart.grayskull.service.interfaces.SecretService;
import com.flipkart.grayskull.spi.AsyncAuditLogger;
import com.flipkart.grayskull.spi.models.AuditEntry;
import com.flipkart.grayskull.spi.models.enums.LifecycleState;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/projects/{projectId}/secrets"})
@Validated
public class SecretController {
    private final SecretService secretService;
    private final AsyncAuditLogger asyncAuditLogger;
    private final RequestUtils requestUtils;

    @Operation(summary="Lists secrets for a given project with pagination. Always returns the latest version of the secret.")
    @GetMapping
    @PreAuthorize(value="@grayskullSecurity.hasPermission(#projectId, 'secrets.list')")
    public ResponseTemplate<ListSecretsResponse> listSecrets(@PathVariable(value="projectId") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String projectId, @RequestParam(name="offset", defaultValue="0") @Min(value=0L) @Min(value=0L) int offset, @RequestParam(name="limit", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int limit) {
        ListSecretsResponse response = this.secretService.listSecrets(projectId, offset, limit);
        return ResponseTemplate.success(response, "Successfully listed secrets.");
    }

    @Operation(summary="Creates a new secret for a given project.")
    @PostMapping
    @PreAuthorize(value="@grayskullSecurity.hasPermission(#projectId, 'secrets.create')")
    public ResponseTemplate<SecretResponse> createSecret(@PathVariable(value="projectId") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String projectId, @Valid @RequestBody CreateSecretRequest request) {
        SecretResponse response = this.secretService.createSecret(projectId, request);
        return ResponseTemplate.success(response, "Successfully created secret.");
    }

    @Operation(summary="Reads the metadata of a specific secret. Always returns the latest version of the secret.")
    @GetMapping(value={"/{secretName}"})
    @PreAuthorize(value="@grayskullSecurity.hasPermission(#projectId, #secretName, 'secrets.read.metadata')")
    public ResponseTemplate<SecretMetadata> readSecretMetadata(@PathVariable(value="projectId") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String projectId, @PathVariable(value="secretName") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String secretName) {
        SecretMetadata response = this.secretService.readSecretMetadata(projectId, secretName);
        return ResponseTemplate.success(response, "Successfully read secret metadata.");
    }

    @Operation(summary="Reads the value of a specific secret. Always returns the latest version of the secret.")
    @GetMapping(value={"/{secretName}/data"})
    @PreAuthorize(value="@grayskullSecurity.hasPermission(#projectId, #secretName, 'secrets.read.value')")
    public ResponseTemplate<SecretDataResponse> readSecretValue(@PathVariable(value="projectId") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String projectId, @PathVariable(value="secretName") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String secretName) {
        SecretDataResponse response = this.secretService.readSecretValue(projectId, secretName);
        Map<String, String> auditMetadata = Map.of("publicPart", response.getPublicPart());
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        AuditEntry auditEntry = AuditEntry.builder().projectId(projectId).resourceType("SECRET").resourceName(secretName).resourceVersion(Integer.valueOf(response.getDataVersion())).action(AuditAction.READ_SECRET.name()).userId(userId).ips(this.requestUtils.getRemoteIPs()).metadata(auditMetadata).build();
        this.asyncAuditLogger.log(auditEntry);
        return ResponseTemplate.success(response, "Successfully read secret value.");
    }

    @Operation(summary="Upgrades the data of an existing secret, creating a new version.")
    @PostMapping(value={"/{secretName}/data"})
    @PreAuthorize(value="@grayskullSecurity.hasPermission(#projectId, #secretName, 'secrets.update')")
    public ResponseTemplate<UpgradeSecretDataResponse> upgradeSecretData(@PathVariable(value="projectId") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String projectId, @PathVariable(value="secretName") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String secretName, @Valid @RequestBody UpgradeSecretDataRequest request) {
        UpgradeSecretDataResponse response = this.secretService.upgradeSecretData(projectId, secretName, request);
        return ResponseTemplate.success(response, "Successfully upgraded secret data.");
    }

    @Operation(summary="Disables a secret, marking it as soft-deleted.")
    @DeleteMapping(value={"/{secretName}"})
    @PreAuthorize(value="@grayskullSecurity.hasPermission(#projectId, #secretName, 'secrets.delete')")
    public ResponseTemplate<Void> deleteSecret(@PathVariable(value="projectId") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String projectId, @PathVariable(value="secretName") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String secretName) {
        this.secretService.deleteSecret(projectId, secretName);
        return ResponseTemplate.success("Successfully deleted secret.");
    }

    @Operation(summary="Retrieves a specific version of a secret's data. Its an Admin API.")
    @GetMapping(value={"/{secretName}/versions/{version}"})
    @PreAuthorize(value="@grayskullSecurity.hasPermission(#projectId, #secretName, 'secrets.read.version')")
    public ResponseTemplate<SecretDataVersionResponse> getSecretDataVersion(@PathVariable(value="projectId") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String projectId, @PathVariable(value="secretName") @NotBlank @Size(max=255) @NotBlank @Size(max=255) String secretName, @PathVariable(value="version") @Min(value=1L) @Min(value=1L) int version, @RequestParam(name="state", required=false) Optional<LifecycleState> state) {
        SecretDataVersionResponse response = this.secretService.getSecretDataVersion(projectId, secretName, version, state);
        Map<String, String> auditMetadata = Map.of("publicPart", response.getPublicPart());
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        AuditEntry auditEntry = AuditEntry.builder().projectId(projectId).resourceType("SECRET").resourceName(secretName).resourceVersion(Integer.valueOf(response.getDataVersion())).action(AuditAction.READ_SECRET_VERSION.name()).userId(userId).ips(this.requestUtils.getRemoteIPs()).metadata(auditMetadata).build();
        this.asyncAuditLogger.log(auditEntry);
        return ResponseTemplate.success(response, "Successfully retrieved secret version.");
    }

    @Generated
    public SecretController(SecretService secretService, AsyncAuditLogger asyncAuditLogger, RequestUtils requestUtils) {
        this.secretService = secretService;
        this.asyncAuditLogger = asyncAuditLogger;
        this.requestUtils = requestUtils;
    }
}

