/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.grayskull.audit.Audit;
import com.flipkart.grayskull.audit.AuditAction;
import com.flipkart.grayskull.audit.utils.RequestUtils;
import com.flipkart.grayskull.audit.utils.SanitizingObjectMapper;
import com.flipkart.grayskull.entities.AuditEntryEntity;
import com.flipkart.grayskull.models.dto.response.SecretResponse;
import com.flipkart.grayskull.models.dto.response.UpgradeSecretDataResponse;
import com.flipkart.grayskull.spi.models.AuditEntry;
import com.flipkart.grayskull.spi.repositories.AuditEntryRepository;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuditAspect {
    private final AuditEntryRepository auditEntryRepository;
    private final RequestUtils requestUtils;

    @AfterReturning(pointcut="@annotation(com.flipkart.grayskull.audit.Audit)", returning="result")
    public void auditSuccess(JoinPoint joinPoint, Object result) {
        Audit audit = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(Audit.class);
        this.audit(joinPoint, audit, result);
    }

    private void audit(JoinPoint joinPoint, Audit audit, Object result) {
        try {
            Map<String, Object> arguments = this.getMethodArguments(joinPoint);
            String projectId = (String)arguments.getOrDefault("projectId", "UNKNOWN");
            String resourceName = this.extractResourceName(result, arguments);
            Integer resourceVersion = this.extractResourceVersion(audit.action(), result);
            Map<String, String> metadata = this.buildMetadata(arguments, result);
            AuditEntry entry = ((AuditEntryEntity.AuditEntryEntityBuilder)((AuditEntryEntity.AuditEntryEntityBuilder)((AuditEntryEntity.AuditEntryEntityBuilder)((AuditEntryEntity.AuditEntryEntityBuilder)((AuditEntryEntity.AuditEntryEntityBuilder)((AuditEntryEntity.AuditEntryEntityBuilder)((AuditEntryEntity.AuditEntryEntityBuilder)((AuditEntryEntity.AuditEntryEntityBuilder)AuditEntryEntity.builder().projectId(projectId)).resourceType("SECRET")).resourceName(resourceName)).resourceVersion(resourceVersion)).action(audit.action().name())).userId(this.getUserId())).ips(this.requestUtils.getRemoteIPs())).metadata(metadata)).build();
            this.auditEntryRepository.save(entry);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize audit metadata", e);
        }
    }

    private String getUserId() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Principal::getName).orElse("system");
    }

    private Map<String, String> buildMetadata(Map<String, Object> arguments, Object result) throws JsonProcessingException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (!arguments.isEmpty()) {
            HashMap<String, Object> requestParams = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                if (entry.getValue() == null) continue;
                requestParams.put(entry.getKey(), entry.getValue());
            }
            if (!requestParams.isEmpty()) {
                metadata.put("request", SanitizingObjectMapper.MASK_OBJECT_MAPPER.writeValueAsString(requestParams));
            }
        }
        if (result != null) {
            metadata.put("result", SanitizingObjectMapper.MASK_OBJECT_MAPPER.writeValueAsString(result));
        }
        return metadata;
    }

    private Integer extractResourceVersion(AuditAction action, Object result) {
        return switch (action) {
            case AuditAction.CREATE_SECRET -> 1;
            case AuditAction.UPGRADE_SECRET_DATA -> {
                if (result instanceof UpgradeSecretDataResponse) {
                    UpgradeSecretDataResponse secretResponse = (UpgradeSecretDataResponse)result;
                    yield secretResponse.getDataVersion();
                }
                yield null;
            }
            default -> null;
        };
    }

    private String extractResourceName(Object result, Map<String, Object> arguments) {
        if (result instanceof SecretResponse) {
            SecretResponse secretResponse = (SecretResponse)result;
            return secretResponse.getName();
        }
        if (result instanceof UpgradeSecretDataResponse) {
            UpgradeSecretDataResponse secretResponse = (UpgradeSecretDataResponse)result;
            return secretResponse.getName();
        }
        Object name = arguments.get("secretName");
        if (name instanceof String) {
            String s = (String)name;
            return s;
        }
        return "UNKNOWN";
    }

    private Map<String, Object> getMethodArguments(JoinPoint joinPoint) {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String[] parameterNames = signature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < parameterNames.length; ++i) {
            argsMap.put(parameterNames[i], args[i]);
        }
        return argsMap;
    }

    @Generated
    public AuditAspect(AuditEntryRepository auditEntryRepository, RequestUtils requestUtils) {
        this.auditEntryRepository = auditEntryRepository;
        this.requestUtils = requestUtils;
    }
}

