/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spimpl.authz;

import com.flipkart.grayskull.configuration.AuthorizationProperties;
import com.flipkart.grayskull.spi.GrayskullAuthorizationProvider;
import com.flipkart.grayskull.spi.authz.AuthorizationContext;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class SimpleAuthorizationProvider
implements GrayskullAuthorizationProvider {
    private final AuthorizationProperties authorizationProperties;

    public boolean isAuthorized(AuthorizationContext authorizationContext, String action) {
        Authentication authentication = authorizationContext.getAuthentication();
        if (authentication == null) {
            return false;
        }
        String username = authentication.getName();
        if (this.authorizationProperties.getRules() == null) {
            return false;
        }
        return this.authorizationProperties.getRules().stream().filter(rule -> this.userMatches((AuthorizationProperties.Rule)rule, username)).filter(rule -> this.projectMatches((AuthorizationProperties.Rule)rule, authorizationContext.getProjectId())).filter(rule -> this.secretMatches((AuthorizationProperties.Rule)rule, authorizationContext.getSecretName().orElse(null))).anyMatch(rule -> this.actionMatches((AuthorizationProperties.Rule)rule, action));
    }

    private boolean userMatches(AuthorizationProperties.Rule rule, String username) {
        return "*".equals(rule.getUser()) || rule.getUser().equals(username);
    }

    private boolean projectMatches(AuthorizationProperties.Rule rule, String projectId) {
        return "*".equals(rule.getProject()) || rule.getProject().equals(projectId);
    }

    private boolean secretMatches(AuthorizationProperties.Rule rule, String secretName) {
        if (rule.getSecret() == null) {
            return true;
        }
        return "*".equals(rule.getSecret()) || rule.getSecret().equals(secretName);
    }

    private boolean actionMatches(AuthorizationProperties.Rule rule, String action) {
        return Optional.ofNullable(rule.getActions()).map(actions -> actions.contains("*") || actions.contains(action)).orElse(false);
    }

    @Generated
    public SimpleAuthorizationProvider(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }
}

