/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spimpl.audit;

import com.flipkart.grayskull.spi.AsyncAuditLogger;
import com.flipkart.grayskull.spi.models.AuditEntry;
import com.flipkart.grayskull.spi.repositories.AuditEntryRepository;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;

public class SimpleAsyncAuditLogger
implements AsyncAuditLogger {
    private final AuditEntryRepository auditEntryRepository;
    private final ExecutorService executorService = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("async-audit-logger").factory());

    public void log(AuditEntry auditEntry) {
        this.executorService.submit(() -> this.auditEntryRepository.save(auditEntry));
    }

    @PreDestroy
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Generated
    public SimpleAsyncAuditLogger(AuditEntryRepository auditEntryRepository) {
        this.auditEntryRepository = auditEntryRepository;
    }
}

