/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.app.audit;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.time.Duration;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="audit")
@Validated
public class AuditProperties {
    @NotEmpty
    private String derbyDirectory;
    @NotEmpty
    private String nodeName;
    @Min(value=1L)
    private @Min(value=1L) int batchSize;
    @NotEmpty
    private String batchTimeInterval;
    private Duration stalenessDuration = Duration.ZERO;

    public String getDerbyUrl() {
        return "jdbc:derby:" + this.derbyDirectory + ";create=true";
    }

    @Generated
    public String getDerbyDirectory() {
        return this.derbyDirectory;
    }

    @Generated
    public String getNodeName() {
        return this.nodeName;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public String getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    @Generated
    public Duration getStalenessDuration() {
        return this.stalenessDuration;
    }

    @Generated
    public void setDerbyDirectory(String derbyDirectory) {
        this.derbyDirectory = derbyDirectory;
    }

    @Generated
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setBatchTimeInterval(String batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    @Generated
    public void setStalenessDuration(Duration stalenessDuration) {
        this.stalenessDuration = stalenessDuration;
    }

    @Generated
    public AuditProperties(String derbyDirectory, String nodeName, int batchSize, String batchTimeInterval, Duration stalenessDuration) {
        this.derbyDirectory = derbyDirectory;
        this.nodeName = nodeName;
        this.batchSize = batchSize;
        this.batchTimeInterval = batchTimeInterval;
        this.stalenessDuration = stalenessDuration;
    }

    @Generated
    public AuditProperties() {
    }
}

