/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.app.audit;

import com.flipkart.grayskull.app.audit.AuditCheckpoint;
import com.flipkart.grayskull.app.audit.AuditCheckpointRepository;
import com.flipkart.grayskull.app.audit.AuditProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileSystemUtils;

public class DerbyStaleDataCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DerbyStaleDataCleaner.class);
    private final AuditCheckpointRepository auditCheckpointRepository;
    private final AuditProperties auditProperties;

    public void cleanStaleData() throws IOException {
        if (this.auditProperties.getStalenessDuration().compareTo(Duration.ZERO) <= 0) {
            log.info("staleness duration is explicitly set to less than or equal to zero so not deleting any data");
            return;
        }
        Optional<AuditCheckpoint> checkpoint = this.auditCheckpointRepository.findByNodeName(this.auditProperties.getNodeName());
        if (checkpoint.isEmpty()) {
            log.info("Checkpoint not present so not deleting any data");
            return;
        }
        if (!checkpoint.get().getLastModifiedAt().isBefore(Instant.now().minus(this.auditProperties.getStalenessDuration()))) {
            log.info("checkpoint is not stale so not deleting the data");
            return;
        }
        log.info("checkpoint is stale, deleting the data");
        this.auditCheckpointRepository.deleteByNodeName(this.auditProperties.getNodeName());
        Path derbyPath = Path.of(this.auditProperties.getDerbyDirectory(), new String[0]).normalize().toAbsolutePath();
        if (Path.of("", new String[0]).toAbsolutePath().startsWith(derbyPath)) {
            throw new IllegalStateException("Invalid Derby directory path: " + String.valueOf(derbyPath));
        }
        if (Files.exists(derbyPath, new LinkOption[0])) {
            FileSystemUtils.deleteRecursively((Path)derbyPath);
        }
    }

    @Generated
    public DerbyStaleDataCleaner(AuditCheckpointRepository auditCheckpointRepository, AuditProperties auditProperties) {
        this.auditCheckpointRepository = auditCheckpointRepository;
        this.auditProperties = auditProperties;
    }
}

