/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.app.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.grayskull.app.audit.DerbyAsyncAuditLogger;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PreDestroy;
import java.sql.SQLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class DerbyAsyncAuditScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DerbyAsyncAuditScheduler.class);
    private final DerbyAsyncAuditLogger derbyAsyncAuditLogger;
    private final MeterRegistry meterRegistry;

    @Scheduled(fixedDelayString="${audit.batch-time-interval}")
    @PreDestroy
    public void run() {
        try {
            int committed;
            while ((committed = this.derbyAsyncAuditLogger.commitBatchToDb()) != 0) {
            }
        }
        catch (JsonProcessingException e) {
            log.error("Failed to deserialize audit entry", (Throwable)e);
            this.meterRegistry.counter("audit-log-error", new String[]{"action", "deserialize", "exception", "JsonProcessingException"}).increment();
        }
        catch (SQLException e) {
            log.error("Failed to connect to Derby", (Throwable)e);
            this.meterRegistry.counter("audit-log-error", new String[]{"action", "fetch-logs", "exception", "SQLException"}).increment();
        }
    }

    @Generated
    public DerbyAsyncAuditScheduler(DerbyAsyncAuditLogger derbyAsyncAuditLogger, MeterRegistry meterRegistry) {
        this.derbyAsyncAuditLogger = derbyAsyncAuditLogger;
        this.meterRegistry = meterRegistry;
    }
}

