/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.app.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.grayskull.app.audit.AuditCheckpoint;
import com.flipkart.grayskull.app.audit.AuditCheckpointRepository;
import com.flipkart.grayskull.app.audit.AuditProperties;
import com.flipkart.grayskull.spi.AsyncAuditLogger;
import com.flipkart.grayskull.spi.models.AuditEntry;
import com.flipkart.grayskull.spi.repositories.AuditEntryRepository;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DerbyAsyncAuditLogger
implements AsyncAuditLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DerbyAsyncAuditLogger.class);
    public static final String AUDIT_ERROR_METRIC = "audit-log-error";
    public static final String ACTION_TAG = "action";
    public static final String EXCEPTION_TAG = "exception";
    private static final String TABLE_ALREADY_EXISTS = "X0Y32";
    private final AuditProperties auditProperties;
    private final Connection connection;
    private final ObjectMapper objectMapper;
    private final MeterRegistry meterRegistry;
    private final AuditEntryRepository auditEntryRepository;
    private final AuditCheckpointRepository auditCheckpointRepository;

    public DerbyAsyncAuditLogger(AuditProperties auditProperties, ObjectMapper objectMapper, MeterRegistry meterRegistry, AuditEntryRepository auditEntryRepository, AuditCheckpointRepository auditCheckpointRepository) throws SQLException {
        this.connection = DriverManager.getConnection(auditProperties.getDerbyUrl());
        this.auditProperties = auditProperties;
        this.objectMapper = objectMapper;
        this.meterRegistry = meterRegistry;
        this.auditEntryRepository = auditEntryRepository;
        this.auditCheckpointRepository = auditCheckpointRepository;
    }

    @PostConstruct
    public void init() throws SQLException {
        block8: {
            try (Statement statement = this.connection.createStatement();){
                statement.execute("CREATE TABLE audits (id BIGINT PRIMARY KEY GENERATED ALWAYS AS IDENTITY(START WITH 1, INCREMENT BY 1), event LONG VARCHAR)");
            }
            catch (SQLException e) {
                if (TABLE_ALREADY_EXISTS.equals(e.getSQLState())) break block8;
                throw e;
            }
        }
    }

    @PreDestroy
    public void cleanup() throws SQLException {
        this.connection.close();
    }

    public void log(AuditEntry auditEntry) {
        try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO audits (event) VALUES (?)");){
            String eventString = this.objectMapper.writeValueAsString((Object)auditEntry);
            statement.setString(1, eventString);
            statement.execute();
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize audit entry", (Throwable)e);
            this.meterRegistry.counter(AUDIT_ERROR_METRIC, new String[]{ACTION_TAG, "serialize", EXCEPTION_TAG, "JsonProcessingException"}).increment();
        }
        catch (SQLException e) {
            log.error("Failed to log audit entry", (Throwable)e);
            this.meterRegistry.counter(AUDIT_ERROR_METRIC, new String[]{ACTION_TAG, "log", EXCEPTION_TAG, "SQLException"}).increment();
        }
    }

    @Transactional
    public int commitBatchToDb() throws SQLException, JsonProcessingException {
        AuditCheckpoint auditCheckpoint = this.auditCheckpointRepository.findByNodeName(this.auditProperties.getNodeName()).orElseGet(() -> new AuditCheckpoint(this.auditProperties.getNodeName()));
        long maxId = auditCheckpoint.getLogId();
        log.info("fetching {} audit entries from checkpoint {}", (Object)this.auditProperties.getBatchSize(), (Object)maxId);
        ArrayList<AuditEntry> auditEntries = new ArrayList<AuditEntry>();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT id, event FROM audits WHERE id > ? ORDER BY id FETCH FIRST ? ROWS ONLY");){
            statement.setLong(1, maxId);
            statement.setInt(2, this.auditProperties.getBatchSize());
            statement.execute();
            ResultSet resultSet = statement.getResultSet();
            while (resultSet.next()) {
                maxId = resultSet.getLong(1);
                String eventSting = resultSet.getString(2);
                AuditEntry auditEntry = (AuditEntry)this.objectMapper.readValue(eventSting, AuditEntry.class);
                auditEntry.getMetadata().put("logId", this.auditProperties.getNodeName() + "." + maxId + "." + String.valueOf(auditEntry.getTimestamp()));
                auditEntries.add(auditEntry);
            }
        }
        log.info("found {} entries. storing them to db. current checkpoint is {}", (Object)auditEntries.size(), (Object)maxId);
        if (!auditEntries.isEmpty()) {
            this.auditEntryRepository.saveAll(auditEntries);
            auditCheckpoint.setLogId(maxId);
            this.auditCheckpointRepository.save(auditCheckpoint);
            statement = this.connection.prepareStatement("DELETE FROM audits WHERE id <= ?");
            try {
                statement.setLong(1, maxId);
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        return auditEntries.size();
    }
}

