/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.serde.handlers.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.gojira.serde.TestSerdeException;
import com.flipkart.gojira.serde.handlers.json.JsonDefaultTestSerdeHandler;
import com.flipkart.gojira.serde.handlers.json.custom.Deserializers;
import com.flipkart.gojira.serde.handlers.json.custom.Serializers;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMapListSerdeHandler
extends JsonDefaultTestSerdeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonMapListSerdeHandler.class);

    public JsonMapListSerdeHandler() {
        super.registerSerializer(List.class, new Serializers.TestListSerializer()).registerDeSerializer(List.class, new Deserializers.TestListDeserializer()).registerSerializer(Map.class, new Serializers.TestMapSerializer()).registerDeSerializer(Map.class, new Deserializers.TestMapDeserializer());
    }

    @Override
    public <T> byte[] serialize(T obj) throws TestSerdeException {
        try {
            return this.mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            LOGGER.trace("error serializing data. class: " + obj.getClass(), (Throwable)e);
            throw new TestSerdeException("error serializing data. class: " + obj.getClass(), e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws TestSerdeException {
        try {
            if (List.class.isAssignableFrom(clazz)) {
                return (T)this.mapper.readValue(bytes, List.class);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return (T)this.mapper.readValue(bytes, Map.class);
            }
            return (T)this.mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            LOGGER.trace("error de-serializing data. class: " + clazz.toGenericString(), (Throwable)e);
            throw new TestSerdeException("error de-serializing data. class: " + clazz.toGenericString(), e);
        }
    }

    @Override
    public <T> void deserializeToInstance(byte[] bytes, T obj) throws TestSerdeException {
        try {
            if (List.class.isAssignableFrom(obj.getClass())) {
                ((List)obj).clear();
                List tmpList = (List)this.mapper.readValue(bytes, List.class);
                ((List)obj).addAll(tmpList);
            } else if (Map.class.isAssignableFrom(obj.getClass())) {
                ((Map)obj).clear();
                Map tmpMap = (Map)this.mapper.readValue(bytes, Map.class);
                ((Map)obj).putAll(tmpMap);
            } else {
                this.mapper.readerForUpdating(obj).readValue(bytes);
            }
        }
        catch (IOException e) {
            LOGGER.trace("error updating object. class: " + obj.getClass(), (Throwable)e);
            throw new TestSerdeException("error updating object. class: " + obj.getClass(), e);
        }
    }
}

