/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.requestsampling.RequestSamplingRepository;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaFilterHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(KafkaFilterHandler.class);

    protected abstract void handle(String var1, byte[] var2, byte[] var3, Map<String, byte[]> var4);

    protected final boolean isWhitelistedTopic(String topic) {
        List<Pattern> whitelistedTopics = ((RequestSamplingRepository)GuiceInjector.getInjector().getInstance(RequestSamplingRepository.class)).getWhitelist();
        for (Pattern whitelistedTopic : whitelistedTopics) {
            if (!whitelistedTopic.matcher(topic).matches()) continue;
            return true;
        }
        LOGGER.trace(String.format("topic: %s is not whitelisted for Gojira... Hence ignoring!", topic));
        return false;
    }

    protected final String getTestId(Map<String, byte[]> headersMap) {
        byte[] id = headersMap.getOrDefault("X-GOJIRA-ID", null);
        return id != null ? new String(id) : null;
    }
}

