/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.gojira.compare.GojiraComparisonModule;
import com.flipkart.gojira.compare.config.GojiraComparisonConfig;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.queuedsender.TestQueuedSenderModule;
import com.flipkart.gojira.queuedsender.config.TestQueuedSenderConfig;
import com.flipkart.gojira.requestsampling.RequestSamplingModule;
import com.flipkart.gojira.requestsampling.config.RequestSamplingConfig;
import com.flipkart.gojira.serde.SerdeModule;
import com.flipkart.gojira.serde.config.SerdeConfig;
import com.flipkart.gojira.sinkstore.config.DataStoreConfig;
import com.flipkart.gojira.sinkstore.config.DataStoreModule;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupModule
extends AbstractModule {
    public static final Logger LOGGER = LoggerFactory.getLogger(SetupModule.class);
    private Mode mode;
    private RequestSamplingConfig requestSamplingConfig;
    private SerdeConfig serdeConfig;
    private GojiraComparisonConfig gojiraComparisonConfig;
    private DataStoreConfig dataStoreConfig;
    private TestQueuedSenderConfig testQueuedSenderConfig;

    public SetupModule(Mode mode, RequestSamplingConfig requestSamplingConfig, SerdeConfig serdeConfig, GojiraComparisonConfig gojiraComparisonConfig, DataStoreConfig dataStoreConfig, TestQueuedSenderConfig testQueuedSenderConfig) {
        this.mode = mode;
        this.requestSamplingConfig = requestSamplingConfig;
        this.serdeConfig = serdeConfig;
        this.gojiraComparisonConfig = gojiraComparisonConfig;
        this.dataStoreConfig = dataStoreConfig;
        this.testQueuedSenderConfig = testQueuedSenderConfig;
    }

    protected void configure() {
        ProfileRepository.setMode(this.mode);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ObjectMapper.class).asEagerSingleton();
                this.install((Module)new RequestSamplingModule(SetupModule.this.requestSamplingConfig));
                this.install((Module)new SerdeModule(SetupModule.this.serdeConfig));
                this.install((Module)new GojiraComparisonModule(SetupModule.this.gojiraComparisonConfig));
                this.install((Module)new DataStoreModule(SetupModule.this.dataStoreConfig));
                this.install((Module)new TestQueuedSenderModule(SetupModule.this.testQueuedSenderConfig));
            }
        }});
        GuiceInjector.assignInjector(injector);
    }
}

