/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.StartEndTestHandler;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.models.TestData;
import com.flipkart.gojira.models.TestDataType;
import com.flipkart.gojira.models.TestRequestData;
import com.flipkart.gojira.models.TestResponseData;
import com.flipkart.gojira.serde.SerdeHandlerRepository;
import com.flipkart.gojira.sinkstore.handlers.SinkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeStartEndTestHandler<T extends TestDataType>
implements StartEndTestHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializeStartEndTestHandler.class);
    private SinkHandler sinkHandler = (SinkHandler)GuiceInjector.getInjector().getInstance(SinkHandler.class);
    private SerdeHandlerRepository serdeHandlerRepository = (SerdeHandlerRepository)GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);

    @Override
    public void start(String id, TestRequestData<T> requestData) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("test id is null");
        }
        try {
            TestData testData = this.serdeHandlerRepository.getTestDataSerdeHandler().deserialize(this.sinkHandler.read(id), TestData.class);
            if (testData == null) {
                throw new RuntimeException("no data available against mentioned test id: " + id);
            }
            ProfileRepository.begin(id);
            ProfileRepository.setTestData(testData);
            ProfileRepository.setRequestMode(Mode.SERIALIZE);
        }
        catch (Exception e) {
            LOGGER.error("unable to fetch data against test id: " + id);
            throw new RuntimeException();
        }
    }

    @Override
    public void end(TestResponseData<T> responseData) {
        ProfileRepository.end();
    }
}

