/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.HttpFilter;
import com.flipkart.gojira.core.HttpFilterHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileState;
import com.flipkart.gojira.models.http.HttpTestRequestData;
import com.flipkart.gojira.models.http.HttpTestResponseData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileHttpFilterHandler
extends HttpFilterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileHttpFilterHandler.class);

    private static Map<String, String> getHeaders(HttpFilter.CustomHttpServletRequestWrapper request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headersMap.put(headerName, request.getHeader(headerName));
            }
        }
        return headersMap;
    }

    @Override
    public boolean preFilter(HttpFilter.CustomHttpServletRequestWrapper request) {
        String id = this.getTestId(request);
        if (id != null) {
            LOGGER.error("Header with name: X-GOJIRA-ID present. But service is running in  PROFILE mode.");
            throw new RuntimeException("Header with name: X-GOJIRA-ID present. But service is running in  PROFILE mode.");
        }
        if (this.isWhitelistedUrl(request.getRequestURI(), request.getMethod())) {
            byte[] body;
            try {
                body = IOUtils.toByteArray((InputStream)request.getInputStream());
            }
            catch (IOException ex) {
                LOGGER.error("Unable to read the stream", (Throwable)ex);
                return true;
            }
            try {
                HttpTestRequestData requestData = HttpTestRequestData.builder().setBody(body).setHeaders(ProfileHttpFilterHandler.getHeaders(request)).setMethod(request.getMethod()).setQueryParams(request.getQueryString()).setUri(request.getRequestURI()).build();
                id = String.valueOf(System.nanoTime()) + Thread.currentThread().getId();
                LOGGER.info(String.format("Gojira generated testId %s for the API call: %s", id, request.getRequestURI()));
                DefaultProfileOrTestHandler.start(id, requestData, Mode.PROFILE);
            }
            catch (Exception e) {
                LOGGER.error("Error trying to construct servelet request");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postFilter(HttpFilter.CustomHttpServletRequestWrapper request, HttpFilter.TestServletResponseWrapper respWrapper, ServletResponse response) throws IOException {
        byte[] outputBuffer = respWrapper.getBuffer();
        response.getOutputStream().write(outputBuffer);
        HttpTestResponseData responseData = null;
        try {
            if (this.isWhitelistedUrl(request.getRequestURI(), request.getMethod())) {
                responseData = HttpTestResponseData.builder().setBody(outputBuffer).setHeaders(this.getHeaders(respWrapper)).setStatusCode(respWrapper.getStatus()).build();
            }
        }
        catch (Exception e) {
            ProfileRepository.setProfileState(ProfileState.FAILED);
            LOGGER.warn("error creating HttpTestRequestData.", (Throwable)e);
        }
        finally {
            try {
                DefaultProfileOrTestHandler.end(responseData);
            }
            catch (Exception e) {
                LOGGER.warn("error ending profiling.", (Throwable)e);
            }
        }
    }
}

