/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.serde.config;

import com.flipkart.gojira.serde.handlers.TestSerdeHandler;
import com.flipkart.gojira.serde.handlers.json.JsonDefaultTestSerdeHandler;

public class SerdeConfig {
    private TestSerdeHandler defaultSerdeHandler = new JsonDefaultTestSerdeHandler();
    private TestSerdeHandler reqRespDataSerdeHandler = new JsonDefaultTestSerdeHandler();
    private TestSerdeHandler testDataSerdeHandler = new JsonDefaultTestSerdeHandler();

    private SerdeConfig() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public TestSerdeHandler getDefaultSerdeHandler() {
        return this.defaultSerdeHandler;
    }

    public TestSerdeHandler getReqRespDataSerdeHandler() {
        return this.reqRespDataSerdeHandler;
    }

    public TestSerdeHandler getTestDataSerdeHandler() {
        return this.testDataSerdeHandler;
    }

    public static class Builder {
        private SerdeConfig serdeConfigToBuild = new SerdeConfig();

        private Builder() {
        }

        public SerdeConfig build() {
            return this.serdeConfigToBuild;
        }

        public Builder setDefaultSerdeHandler(TestSerdeHandler testSerdeHandler) {
            this.serdeConfigToBuild.defaultSerdeHandler = testSerdeHandler;
            return this;
        }

        private Builder setReqRespDataSerdeHandler(TestSerdeHandler testSerdeHandler) {
            this.serdeConfigToBuild.reqRespDataSerdeHandler = testSerdeHandler;
            return this;
        }

        private Builder setTestDataSerdeHandler(TestSerdeHandler testSerdeHandler) {
            this.serdeConfigToBuild.testDataSerdeHandler = testSerdeHandler;
            return this;
        }
    }
}

