/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.models.rmq;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.inject.Singleton;
import com.rabbitmq.client.AMQP;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class RmqPropertiesDeserializer
extends JsonDeserializer<AMQP.BasicProperties> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public AMQP.BasicProperties deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        TreeNode treeNode = jsonParser.getCodec().readTree(jsonParser);
        TreeNode headersTreeNode = treeNode.get("headers");
        String headersAsStr = headersTreeNode.toString();
        TypeFactory typeFactory = objectMapper.getTypeFactory();
        MapType mapType = typeFactory.constructMapType(HashMap.class, String.class, Object.class);
        Map headersMap = (Map)objectMapper.readValue(headersAsStr, (JavaType)mapType);
        String contentType = this.getStringValue("contentType", treeNode);
        String contentEncoding = this.getStringValue("contentEncoding", treeNode);
        Integer deliveryMode = this.getIntegerValue("deliveryMode", treeNode);
        Integer priority = this.getIntegerValue("priority", treeNode);
        String correlationId = this.getStringValue("correlationId", treeNode);
        String replyTo = this.getStringValue("replyTo", treeNode);
        String expiration = this.getStringValue("expiration", treeNode);
        String messageId = this.getStringValue("messageId", treeNode);
        Date timestamp = (Date)objectMapper.treeToValue(treeNode.get("timestamp"), Date.class);
        String type = this.getStringValue("type", treeNode);
        String userId = this.getStringValue("userId", treeNode);
        String appId = this.getStringValue("appId", treeNode);
        String clusterId = this.getStringValue("clusterId", treeNode);
        return new AMQP.BasicProperties(contentType, contentEncoding, headersMap, deliveryMode, priority, correlationId, replyTo, expiration, messageId, timestamp, type, userId, appId, clusterId);
    }

    private String getStringValue(String propertyName, TreeNode treeNode) throws IOException {
        if (treeNode == null || propertyName == null) {
            return null;
        }
        TreeNode propertyTree = treeNode.get(propertyName);
        if (propertyTree == null) {
            return null;
        }
        return (String)objectMapper.treeToValue(treeNode.get(propertyName), String.class);
    }

    private Integer getIntegerValue(String propertyName, TreeNode treeNode) throws JsonProcessingException {
        if (treeNode == null || propertyName == null) {
            return null;
        }
        TreeNode propertyTree = treeNode.get(propertyName);
        if (propertyTree == null) {
            return null;
        }
        return (Integer)objectMapper.treeToValue(treeNode.get(propertyName), Integer.class);
    }
}

