/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.RmqFilterHandler;
import com.flipkart.gojira.models.rmq.RmqTestRequestData;
import com.rabbitmq.client.AMQP;

public class ProfileRmqFilterHandler
extends RmqFilterHandler {
    @Override
    protected void handle(String exchangeName, byte[] key, byte[] value, AMQP.BasicProperties basicProperties, boolean mandatory) {
        String id = this.getTestId(basicProperties);
        if (id != null) {
            LOGGER.error("Header with name: X-GOJIRA-ID present. But service is not running in  mode. : " + (Object)((Object)Mode.PROFILE));
            throw new RuntimeException("Header with name: X-GOJIRA-ID present. But service is not running in  mode. : " + (Object)((Object)Mode.PROFILE));
        }
        if (!this.isExchangeWhitelisted(exchangeName)) {
            LOGGER.error("Exchange is not whitelisted. Exchange name :{}", (Object)exchangeName);
            return;
        }
        id = String.valueOf(System.nanoTime()) + Thread.currentThread().getId();
        RmqTestRequestData rmqTestRequestData = RmqTestRequestData.builder().setExchangeName(exchangeName).setRoutingKey(key).setData(value).setProperties(basicProperties).setMandatory(mandatory).build();
        try {
            DefaultProfileOrTestHandler.start(id, rmqTestRequestData, Mode.PROFILE);
        }
        catch (Exception e) {
            LOGGER.error("Exception trying to construct RmqTestRequest. ", (Throwable)e);
        }
    }
}

