/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.KafkaFilterHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.models.kafka.KafkaTestRequestData;
import java.util.Map;

public class ProfileKafkaFilterHandler
extends KafkaFilterHandler {
    @Override
    protected void handle(String topicName, byte[] key, byte[] value, Map<String, byte[]> headersMap) {
        String id = this.getTestId(headersMap);
        if (id != null) {
            LOGGER.error("Header with name: X-GOJIRA-ID present. But service is not running in TEST mode. : " + (Object)((Object)Mode.PROFILE));
            throw new RuntimeException("Header with name: X-GOJIRA-ID present. But service is not running in TEST mode. : " + (Object)((Object)Mode.PROFILE));
        }
        if (!this.isWhitelistedTopic(topicName)) {
            return;
        }
        id = String.valueOf(System.nanoTime()) + Thread.currentThread().getId();
        KafkaTestRequestData kafkaTestRequestData = KafkaTestRequestData.builder().setTopicName(topicName).setKey(key).setValue(value).setHeaders(headersMap).build();
        try {
            DefaultProfileOrTestHandler.start(id, kafkaTestRequestData, Mode.PROFILE);
        }
        catch (Exception e) {
            LOGGER.error("Exception trying to construct KafkaTestRequest. ", (Throwable)e);
        }
    }
}

