/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.serde.handlers.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.gojira.serde.TestSerdeException;
import com.flipkart.gojira.serde.handlers.TestSerdeHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JsonTestSerdeHandler
implements TestSerdeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonTestSerdeHandler.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final SimpleModule module = new SimpleModule();

    public static synchronized <T> void registerSerializer(Class<T> type, JsonSerializer<T> ser) {
        module.addSerializer(type, ser);
        mapper.registerModule((Module)module);
        TestMapSerializer.registerSerializer(type, ser);
        TestListDeserializer.registerSerializer(type, ser);
        TestMapDeserializer.registerSerializer(type, ser);
    }

    public static synchronized <T> void registerDeSerializer(Class<T> type, JsonDeserializer<T> deser) {
        module.addDeserializer(type, deser);
        mapper.registerModule((Module)module);
        TestMapSerializer.registerDeserializer(type, deser);
        TestListDeserializer.registerDeserializer(type, deser);
        TestMapDeserializer.registerDeserializer(type, deser);
    }

    private static void setUpMapperProperties(ObjectMapper mapper) {
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSubtypeResolver((SubtypeResolver)new StdSubtypeResolver());
    }

    @Override
    public <T> byte[] serialize(T obj) throws TestSerdeException {
        try {
            return mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("error serializing data.", (Throwable)e);
            throw new TestSerdeException("error serializing data.", e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws TestSerdeException {
        try {
            if (List.class.isAssignableFrom(clazz)) {
                return (T)mapper.readValue(bytes, List.class);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return (T)mapper.readValue(bytes, Map.class);
            }
            return (T)mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            LOGGER.error("error de-serializing data. class: " + clazz.toGenericString(), (Throwable)e);
            throw new TestSerdeException("error de-serializing data. class: " + clazz.toGenericString(), e);
        }
    }

    @Override
    public <T> void deserializeToInstance(byte[] bytes, T obj) throws TestSerdeException {
        try {
            mapper.readerForUpdating(obj).readValue(bytes);
        }
        catch (IOException e) {
            throw new TestSerdeException("error updating object.", e);
        }
    }

    static {
        JsonTestSerdeHandler.setUpMapperProperties(mapper);
        JsonTestSerdeHandler.registerSerializer(List.class, new TestListSerializer());
        JsonTestSerdeHandler.registerDeSerializer(List.class, new TestListDeserializer());
        JsonTestSerdeHandler.registerSerializer(Map.class, new TestMapSerializer());
        JsonTestSerdeHandler.registerDeSerializer(Map.class, new TestMapDeserializer());
        mapper.registerModule((Module)module);
    }

    public static class TestMapDeserializer
    extends JsonDeserializer<Map> {
        private static ObjectMapper mapper = new ObjectMapper();
        private static SimpleModule module = new SimpleModule();
        private static ObjectMapper recursiveMapper = new ObjectMapper();
        private static SimpleModule recursiveModule = new SimpleModule();

        static synchronized <T> void registerSerializer(Class<T> type, JsonSerializer<T> ser) {
            module.addSerializer(type, ser);
            mapper.registerModule((Module)module);
            recursiveModule.addSerializer(type, ser);
            mapper.registerModule((Module)recursiveModule);
        }

        static synchronized <T> void registerDeserializer(Class<T> type, JsonDeserializer<T> deser) {
            module.addDeserializer(type, deser);
            mapper.registerModule((Module)module);
            recursiveModule.addDeserializer(type, deser);
            mapper.registerModule((Module)recursiveModule);
        }

        public Map deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map map;
            String mapType;
            ObjectCodec oc = p.getCodec();
            ArrayNode arrayNode = (ArrayNode)oc.readTree(p);
            String string = mapType = arrayNode.get(0) != null ? arrayNode.get(0).get("TestMapSerializer|mapType").asText() : null;
            if (mapType == null) {
                return new HashMap();
            }
            arrayNode.remove(0);
            try {
                map = (Map)Class.forName(mapType).newInstance();
            }
            catch (Exception e) {
                LOGGER.error("Error creating new map of type " + mapType + " in JsonTestSerdeHandler. ", (Throwable)e);
                throw new IOException("Error creating new map instance in JsonTestSerdeHandler. ", e);
            }
            if (arrayNode.size() == 0) {
                return map;
            }
            try {
                Iterator elements = arrayNode.elements();
                String mapKeyType = null;
                String mapValueType = null;
                boolean mapKey = true;
                boolean mapValue = false;
                while (elements.hasNext()) {
                    ObjectNode element = (ObjectNode)elements.next();
                    Iterator keys = element.fieldNames();
                    if (mapKey || mapValue) {
                        if (mapKey) {
                            mapKeyType = element.get("TestMapSerializer|mapElementKeyType").asText();
                            mapKey = false;
                            mapValue = true;
                            continue;
                        }
                        mapValueType = element.get("TestMapSerializer|mapElementValueType").asText();
                        mapValue = false;
                        continue;
                    }
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        map.put(Map.class.isAssignableFrom(Class.forName(mapKeyType)) ? recursiveMapper.readValue(key.getBytes(), Map.class) : mapper.readValue(key.getBytes(), Class.forName(mapKeyType)), Map.class.isAssignableFrom(Class.forName(mapValueType)) ? recursiveMapper.readValue(element.get(key).toString().getBytes(), Map.class) : mapper.readValue(element.get(key).toString().getBytes(), Class.forName(mapValueType)));
                    }
                    mapKey = true;
                }
                return map;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("class cast exception", e);
            }
        }

        static {
            JsonTestSerdeHandler.setUpMapperProperties(TestMapDeserializer.mapper);
            JsonTestSerdeHandler.setUpMapperProperties(TestMapDeserializer.recursiveMapper);
            module.addSerializer(List.class, (JsonSerializer)new TestListSerializer());
            module.addDeserializer(List.class, (JsonDeserializer)new TestListDeserializer());
            recursiveModule.addSerializer(List.class, (JsonSerializer)new TestListSerializer());
            recursiveModule.addDeserializer(List.class, (JsonDeserializer)new TestListDeserializer());
            recursiveModule.addSerializer(Map.class, (JsonSerializer)new TestMapSerializer());
            recursiveModule.addDeserializer(Map.class, (JsonDeserializer)new TestMapDeserializer());
            mapper.registerModule((Module)module);
            recursiveMapper.registerModule((Module)recursiveModule);
        }
    }

    public static class TestMapSerializer
    extends JsonSerializer<Map> {
        private static ObjectMapper mapper = new ObjectMapper();
        private static SimpleModule module = new SimpleModule();

        public static synchronized <T> void registerSerializer(Class<T> type, JsonSerializer<T> ser) {
            module.addSerializer(type, ser);
            mapper.registerModule((Module)module);
        }

        public static synchronized <T> void registerDeserializer(Class<T> type, JsonDeserializer<T> deser) {
            module.addDeserializer(type, deser);
            mapper.registerModule((Module)module);
        }

        public void serialize(Map value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            String mapType = value.getClass().getName();
            gen.writeStartArray();
            gen.writeStartObject();
            gen.writeStringField("TestMapSerializer|mapType", mapType);
            gen.writeEndObject();
            if (!value.isEmpty()) {
                int size = value.size();
                for (int i = 0; i < size; ++i) {
                    if (value.keySet().toArray()[i] == null || value.get(value.keySet().toArray()[i]) == null) continue;
                    gen.writeStartObject();
                    gen.writeStringField("TestMapSerializer|mapElementKeyType", value.keySet().toArray()[i].getClass().getName());
                    gen.writeEndObject();
                    gen.writeStartObject();
                    gen.writeStringField("TestMapSerializer|mapElementValueType", value.get(value.keySet().toArray()[i]).getClass().getName());
                    gen.writeEndObject();
                    gen.writeStartObject();
                    gen.writeObjectField(mapper.writeValueAsString(value.keySet().toArray()[i]), value.get(value.keySet().toArray()[i]));
                    gen.writeEndObject();
                }
            }
            gen.writeEndArray();
        }

        static {
            JsonTestSerdeHandler.setUpMapperProperties(TestMapSerializer.mapper);
            module.addSerializer(List.class, (JsonSerializer)new TestListSerializer());
            module.addDeserializer(List.class, (JsonDeserializer)new TestListDeserializer());
            mapper.registerModule((Module)module);
        }
    }

    public static class TestListDeserializer
    extends JsonDeserializer<List> {
        private static ObjectMapper mapper = new ObjectMapper();
        private static SimpleModule module = new SimpleModule();
        private static ObjectMapper recursiveMapper = new ObjectMapper();
        private static SimpleModule recursiveModule = new SimpleModule();

        static synchronized <T> void registerSerializer(Class<T> type, JsonSerializer<T> ser) {
            module.addSerializer(type, ser);
            mapper.registerModule((Module)module);
            recursiveModule.addSerializer(type, ser);
            mapper.registerModule((Module)recursiveModule);
        }

        static synchronized <T> void registerDeserializer(Class<T> type, JsonDeserializer<T> deser) {
            module.addDeserializer(type, deser);
            mapper.registerModule((Module)module);
            recursiveModule.addDeserializer(type, deser);
            mapper.registerModule((Module)recursiveModule);
        }

        public List deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            List list;
            ObjectCodec oc = p.getCodec();
            JsonNode jsonNode = (JsonNode)oc.readTree(p);
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            String listType = arrayNode.get(0).asText();
            try {
                list = (List)Class.forName(arrayNode.get(0).asText()).newInstance();
            }
            catch (Exception e) {
                LOGGER.error("Error creating new list of type " + listType + " in JsonTestSerdeHandler. ", (Throwable)e);
                throw new IOException("Error creating new list instance in JsonTestSerdeHandler. ", e);
            }
            if (arrayNode.get(1) == null) {
                return list;
            }
            arrayNode.remove(0);
            try {
                boolean itemType = true;
                String listItemType = null;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    if (itemType) {
                        listItemType = arrayNode.get(i).asText();
                        itemType = false;
                        continue;
                    }
                    list.add(List.class.isAssignableFrom(Class.forName(listItemType)) ? recursiveMapper.readValue(arrayNode.get(i).toString().getBytes(), List.class) : mapper.readValue(arrayNode.get(i).toString().getBytes(), Class.forName(listItemType)));
                    itemType = true;
                }
                return list;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("ClassNotFoundException exception", e);
            }
        }

        static {
            JsonTestSerdeHandler.setUpMapperProperties(TestListDeserializer.mapper);
            JsonTestSerdeHandler.setUpMapperProperties(TestListDeserializer.recursiveMapper);
            module.addSerializer(Map.class, (JsonSerializer)new TestMapSerializer());
            module.addDeserializer(Map.class, (JsonDeserializer)new TestMapDeserializer());
            recursiveModule.addSerializer(List.class, (JsonSerializer)new TestListSerializer());
            recursiveModule.addDeserializer(List.class, (JsonDeserializer)new TestListDeserializer());
            recursiveModule.addSerializer(Map.class, (JsonSerializer)new TestMapSerializer());
            recursiveModule.addDeserializer(Map.class, (JsonDeserializer)new TestMapDeserializer());
            mapper.registerModule((Module)module);
            recursiveMapper.registerModule((Module)recursiveModule);
        }
    }

    public static class TestListSerializer
    extends JsonSerializer<List> {
        public void serialize(List value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String listType = value.getClass().getName();
            gen.writeStartArray();
            gen.writeString(listType);
            if (!value.isEmpty()) {
                for (Object element : value) {
                    if (element == null) continue;
                    gen.writeObject((Object)element.getClass().getName());
                    gen.writeObject(element);
                }
            }
            gen.writeEndArray();
        }
    }
}

