/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.execute.rmq;

import com.flipkart.gojira.execute.TestExecutor;
import com.flipkart.gojira.external.rmq.IRmqHelper;
import com.flipkart.gojira.external.rmq.RmqPublishException;
import com.flipkart.gojira.models.TestData;
import com.flipkart.gojira.models.rmq.RmqTestDataType;
import com.flipkart.gojira.models.rmq.RmqTestRequestData;
import com.flipkart.gojira.models.rmq.RmqTestResponseData;
import com.google.inject.Inject;
import com.rabbitmq.client.AMQP;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRmqTestExecutor
implements TestExecutor<TestData<RmqTestRequestData, RmqTestResponseData, RmqTestDataType>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRmqTestExecutor.class);
    private final IRmqHelper rmqHelper;

    @Inject
    public DefaultRmqTestExecutor(IRmqHelper rmqHelper) {
        this.rmqHelper = rmqHelper;
    }

    @Override
    public void execute(TestData<RmqTestRequestData, RmqTestResponseData, RmqTestDataType> testData, String clientId) throws RmqPublishException {
        String testId = testData.getId();
        RmqTestRequestData requestData = testData.getRequestData();
        AMQP.BasicProperties basicProperties = requestData.getProperties();
        HashMap<String, String> headers = basicProperties.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("X-GOJIRA-ID", testId);
        AMQP.BasicProperties alteredProperties = basicProperties.builder().headers(headers).build();
        try {
            this.rmqHelper.publish(clientId, requestData.getExchangeName(), requestData.getRoutingKey(), requestData.getData(), alteredProperties, requestData.isMandatory());
        }
        catch (RmqPublishException e) {
            LOGGER.error("Unable to publish through RMQ with clientId :{} and testID:{}", new Object[]{clientId, testId, e});
            throw e;
        }
        this.logRecordPublish(requestData.getExchangeName(), requestData.getRoutingKey(), requestData.getData(), clientId, testId);
    }

    private void logRecordPublish(String exchangeName, byte[] routingKey, byte[] data, String clientId, String testId) {
        LOGGER.info("published data to exchange: " + exchangeName + " with routingKey: " + new String(routingKey) + " with data " + new String(data) + " with clientId: " + clientId + " for testId: " + testId + ". ");
    }
}

