/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.rmq;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.ExternalConfigRepository;
import com.flipkart.gojira.external.Managed;
import com.flipkart.gojira.external.SetupException;
import com.flipkart.gojira.external.ShutdownException;
import com.flipkart.gojira.external.config.ExternalConfig;
import com.flipkart.gojira.external.config.RMQConfig;
import com.flipkart.gojira.external.rmq.IRMQManager;
import com.flipkart.gojira.models.rmq.RMQTestDataType;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RMQManager implements IRMQManager,
Managed
{
    RMQ_MANAGER;

    private static final Logger logger;

    @Override
    public void setup() throws SetupException {
        try {
            Map<String, ExternalConfig> externalConfigMap = ((ExternalConfigRepository)TestExecutionInjector.getInjector().getInstance(ExternalConfigRepository.class)).getExternalConfigByType(RMQTestDataType.class);
            if (!externalConfigMap.isEmpty()) {
                for (Map.Entry<String, ExternalConfig> entry : externalConfigMap.entrySet()) {
                    ExternalConfig externalConfig = entry.getValue();
                    if (externalConfig == null) continue;
                    RMQConfig rmqConfig = (RMQConfig)externalConfig;
                    clientVsChannelMap.put(entry.getKey(), this.createChannel(rmqConfig));
                }
            }
        }
        catch (Exception e) {
            logger.error("error setting up rmq connections.", (Throwable)e);
            throw new SetupException("error setting up rmq connections.", e);
        }
    }

    @Override
    public void shutdown() throws ShutdownException {
        try {
            for (Map.Entry entry : clientVsChannelMap.entrySet()) {
                this.stopConsumer((Channel)entry.getValue());
            }
        }
        catch (Exception e) {
            logger.error("error closing http connections.", (Throwable)e);
            throw new ShutdownException("error closing http connections.", e);
        }
    }

    private Channel createChannel(RMQConfig rmqConfig) throws SetupException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(rmqConfig.getUsername());
        factory.setPassword(rmqConfig.getPassword());
        factory.setVirtualHost(rmqConfig.getVirtualHost());
        factory.setAutomaticRecoveryEnabled(rmqConfig.isAutomaticRecoveryEnabled());
        LinkedList<Address> addressList = new LinkedList<Address>();
        for (String endpoint : rmqConfig.getEndpoints()) {
            addressList.add(new Address(endpoint, rmqConfig.getPort()));
            logger.info("Adding the RMQ endpoint [" + endpoint + ":" + rmqConfig.getPort() + "] in connection factory");
        }
        Address[] addrArr = addressList.toArray(new Address[0]);
        logger.info("Number of nodes connected to in RMQ:" + addrArr.length);
        try {
            Connection connection = factory.newConnection(addrArr);
            Channel rmqChannel = connection.createChannel();
            logger.info("Connection to RMQ established.." + rmqChannel.getConnection().getAddress().getHostName());
            return rmqChannel;
        }
        catch (IOException | TimeoutException e) {
            String errorMsg = "Connection to RMQ could not be established..";
            logger.error(errorMsg);
            throw new SetupException(errorMsg);
        }
    }

    private void stopConsumer(Channel channel) {
        try {
            logger.info("Stopping Consumer Service");
            if (channel.getConnection().isOpen()) {
                logger.info("closing RabbitMQ channel...");
                channel.getConnection().close();
            }
            if (channel.isOpen()) {
                channel.close();
            }
        }
        catch (Exception e) {
            logger.error("Exception while closing channel", (Throwable)e);
        }
    }

    @Override
    public Channel getChannelByClient(String client) {
        return (Channel)clientVsChannelMap.get(client);
    }

    static {
        logger = LoggerFactory.getLogger(RMQManager.class);
    }
}

