/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.rmq;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.rmq.IRMQHelper;
import com.flipkart.gojira.external.rmq.IRMQManager;
import com.flipkart.gojira.external.rmq.RMQPublishException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQHelper
implements IRMQHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMQHelper.class);

    @Override
    public void publish(String clientId, String exchangeName, byte[] routingKey, byte[] data, AMQP.BasicProperties properties, boolean mandatory) throws RMQPublishException {
        Channel channel = ((IRMQManager)TestExecutionInjector.getInjector().getInstance(IRMQManager.class)).getChannelByClient(clientId);
        if (channel == null) {
            LOGGER.error("Unable to publish as cannot instantiate channel");
            throw new RMQPublishException("Unable to publish as cannot instantiate channel");
        }
        try {
            String routingParam = new String(routingKey);
            channel.basicPublish(exchangeName, routingParam, mandatory, properties, data);
        }
        catch (Exception e) {
            LOGGER.error("Unable to publish to RMq channel", (Throwable)e);
            throw new RMQPublishException("Unable to publish to RMq channel", e);
        }
    }
}

