/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.execute.rmq;

import com.flipkart.gojira.execute.TestExecutionException;
import com.flipkart.gojira.execute.TestExecutor;
import com.flipkart.gojira.external.rmq.IRMQHelper;
import com.flipkart.gojira.external.rmq.RMQPublishException;
import com.flipkart.gojira.models.TestData;
import com.flipkart.gojira.models.rmq.RMQTestDataType;
import com.flipkart.gojira.models.rmq.RMQTestRequestData;
import com.flipkart.gojira.models.rmq.RMQTestResponseData;
import com.google.inject.Inject;
import com.rabbitmq.client.AMQP;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRMQTestExecutor
implements TestExecutor<TestData<RMQTestRequestData, RMQTestResponseData, RMQTestDataType>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRMQTestExecutor.class);
    private final IRMQHelper rmqHelper;

    @Inject
    public DefaultRMQTestExecutor(IRMQHelper rmqHelper) {
        this.rmqHelper = rmqHelper;
    }

    @Override
    public void execute(TestData<RMQTestRequestData, RMQTestResponseData, RMQTestDataType> testData) throws TestExecutionException {
        this.execute(testData, "DEFAULT");
    }

    @Override
    public void execute(TestData<RMQTestRequestData, RMQTestResponseData, RMQTestDataType> testData, String clientId) throws RMQPublishException {
        String testId = testData.getId();
        RMQTestRequestData requestData = testData.getRequestData();
        AMQP.BasicProperties basicProperties = requestData.getProperties();
        HashMap<String, String> headers = basicProperties.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("X-GOJIRA-ID", testId);
        AMQP.BasicProperties alteredProperties = basicProperties.builder().headers(headers).build();
        try {
            this.rmqHelper.publish(clientId, requestData.getExchangeName(), requestData.getRoutingKey(), requestData.getData(), alteredProperties, requestData.isMandatory());
        }
        catch (RMQPublishException e) {
            LOGGER.error("Unable to publish through RMQ with clientId :{} and testID:{}", new Object[]{clientId, testId, e});
            throw e;
        }
        this.logRecordPublish(requestData.getExchangeName(), requestData.getRoutingKey(), requestData.getData(), clientId, testId);
    }

    private void logRecordPublish(String exchangeName, byte[] routingKey, byte[] data, String clientId, String testId) {
        LOGGER.info(String.format("published data to exchange: %s with routingKey: %s with data %s with clientId: %s for testId: %s. ", exchangeName, new String(routingKey), new String(data), clientId, testId));
    }
}

