/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.NoneRMQFilterHandler;
import com.flipkart.gojira.core.ProfileRMQFilterHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.RMQFilterHandler;
import com.flipkart.gojira.core.SerializeRMQFilterHandler;
import com.flipkart.gojira.core.TestRMQFilterHandler;
import com.flipkart.gojira.models.rmq.RMQTestResponseData;
import com.rabbitmq.client.AMQP;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMQFilter.class);
    private static final Map<Mode, RMQFilterHandler> filterHashMap = Collections.unmodifiableMap(new HashMap<Mode, RMQFilterHandler>(){
        {
            this.put(Mode.NONE, new NoneRMQFilterHandler());
            this.put(Mode.PROFILE, new ProfileRMQFilterHandler());
            this.put(Mode.TEST, new TestRMQFilterHandler());
            this.put(Mode.SERIALIZE, new SerializeRMQFilterHandler());
        }
    });

    public void start(String exchangeName, byte[] routingKey, byte[] data, AMQP.BasicProperties basicProperties, boolean mandatory) {
        filterHashMap.getOrDefault((Object)ProfileRepository.getMode(), new NoneRMQFilterHandler()).handle(exchangeName, routingKey, data, basicProperties, mandatory);
    }

    public void end(byte[] bytes) {
        RMQTestResponseData rmqTestResponseData = RMQTestResponseData.builder().setRespondData(bytes).build();
        DefaultProfileOrTestHandler.end(rmqTestResponseData);
    }
}

