/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.http;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.ExternalConfigRepository;
import com.flipkart.gojira.external.Managed;
import com.flipkart.gojira.external.SetupException;
import com.flipkart.gojira.external.ShutdownException;
import com.flipkart.gojira.external.config.ExternalConfig;
import com.flipkart.gojira.external.http.IHttpManager;
import java.util.Map;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HttpManager implements IHttpManager,
Managed
{
    HTTP_MANAGER;

    private static final Logger LOGGER;

    @Override
    public void setup() throws SetupException {
        try {
            for (Map.Entry<String, ExternalConfig> entry : ((ExternalConfigRepository)TestExecutionInjector.getInjector().getInstance(ExternalConfigRepository.class)).getExternalConfig().entrySet()) {
                clientMap.put(entry.getKey(), new DefaultAsyncHttpClient((AsyncHttpClientConfig)new DefaultAsyncHttpClientConfig.Builder().setConnectTimeout(entry.getValue().getConnectionTimeout()).setMaxConnections(entry.getValue().getMaxConnections()).setMaxConnectionsPerHost(entry.getValue().getMaxConnections()).setKeepAlive(true).setRequestTimeout(entry.getValue().getOperationTimeout()).build()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error setting up http connections.", (Throwable)e);
            throw new SetupException("error setting up http connections.", e);
        }
    }

    @Override
    public DefaultAsyncHttpClient getClient(String key) {
        return (DefaultAsyncHttpClient)clientMap.get(key);
    }

    @Override
    public void shutdown() throws ShutdownException {
        try {
            for (Map.Entry entry : clientMap.entrySet()) {
                ((DefaultAsyncHttpClient)entry.getValue()).close();
            }
        }
        catch (Exception e) {
            LOGGER.error("error closing http connections.", (Throwable)e);
            throw new ShutdownException("error closing http connections.", e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(HttpManager.class);
    }
}

