/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.HttpFilter;
import com.flipkart.gojira.core.HttpFilterHandler;
import java.io.IOException;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeHttpFilterHandler
extends HttpFilterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializeHttpFilterHandler.class);

    @Override
    public boolean preFilter(HttpFilter.CustomHttpServletRequestWrapper request) {
        String id = super.getTestId(request);
        if (id == null) {
            LOGGER.error("X-GOJIRA-ID header not present but the service is running in SERIALIZE mode.");
            throw new RuntimeException("X-GOJIRA-ID header not present but the service is running in SERIALIZE mode.");
        }
        boolean whitelisted = this.isWhitelistedURL(request.getRequestURI(), request.getMethod());
        if (whitelisted) {
            DefaultProfileOrTestHandler.start(id, null);
        }
        return whitelisted;
    }

    @Override
    protected void postFilter(HttpFilter.CustomHttpServletRequestWrapper request, HttpFilter.TestServletResponseWrapper respWrapper, ServletResponse response) throws IOException {
        byte[] outputBuffer = respWrapper.getBuffer();
        response.getOutputStream().write(outputBuffer);
        if (this.isWhitelistedURL(request.getRequestURI(), request.getMethod())) {
            DefaultProfileOrTestHandler.end(null);
        }
    }
}

