/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.execute.http;

import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.execute.TestExecutor;
import com.flipkart.gojira.external.http.HttpCallException;
import com.flipkart.gojira.external.http.IHttpHelper;
import com.flipkart.gojira.models.TestData;
import com.flipkart.gojira.models.http.HttpTestDataType;
import com.flipkart.gojira.models.http.HttpTestRequestData;
import com.flipkart.gojira.models.http.HttpTestResponseData;
import com.google.inject.Inject;
import java.util.HashMap;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpTestExecutor
implements TestExecutor<TestData<HttpTestRequestData, HttpTestResponseData, HttpTestDataType>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpTestExecutor.class);
    private final IHttpHelper httpHelper;

    @Inject
    public DefaultHttpTestExecutor(IHttpHelper httpHelper) {
        this.httpHelper = httpHelper;
    }

    @Override
    public void execute(TestData<HttpTestRequestData, HttpTestResponseData, HttpTestDataType> testData, String clientId) throws HttpCallException {
        HttpTestRequestData requestData = testData.getRequestData();
        String testId = testData.getId();
        LOGGER.trace("key :" + testId);
        String requestUri = requestData.getUri();
        String queryParamsWithDelimiter = requestData.getQueryParams() == null ? "" : "?" + requestData.getQueryParams();
        String urlWithQueryParams = requestUri + queryParamsWithDelimiter;
        HashMap<String, String> headers = requestData.getHeaders() != null ? requestData.getHeaders() : new HashMap<String, String>();
        headers.remove("Content-Length");
        headers.put("X-GOJIRA-ID", testId);
        headers.put("X-GOJIRA-MODE", Mode.TEST.name());
        String httpMethod = requestData.getMethod().toUpperCase();
        Response response = null;
        switch (httpMethod) {
            case "GET": {
                response = this.httpHelper.doGet(clientId, urlWithQueryParams, headers);
                break;
            }
            case "POST": {
                response = this.httpHelper.doPost(clientId, urlWithQueryParams, headers, requestData.getBody());
                break;
            }
            case "PUT": {
                response = this.httpHelper.doPut(clientId, urlWithQueryParams, headers, requestData.getBody());
                break;
            }
            case "DELETE": {
                response = this.httpHelper.doDelete(clientId, urlWithQueryParams, headers);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported Http Method: " + httpMethod);
            }
        }
        this.logExternalCall(response, urlWithQueryParams, clientId, testId);
    }

    private void logExternalCall(Response response, String urlWithQueryParams, String clientId, String testId) {
        LOGGER.debug(String.format("made an external call to uri: %s with clientId: %s for testId: %s. Response received: %d", urlWithQueryParams, clientId, testId, response != null ? response.getStatusCode() : -1));
    }
}

