/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.MethodDataInterceptorHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.NoneMethodDataInterceptorHandler;
import com.flipkart.gojira.core.ProfileMethodDataInterceptorHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.SerializeMethodDataInterceptorHandler;
import com.flipkart.gojira.core.TestMethodDataInterceptorHandler;
import com.flipkart.gojira.core.TransformMethodDataInterceptorHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileOrTestMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileOrTestMethodInterceptor.class);
    private Map<Mode, MethodDataInterceptorHandler> modeMethodDataInterceptorHandlerMap = Collections.unmodifiableMap(new HashMap<Mode, MethodDataInterceptorHandler>(){
        {
            this.put(Mode.NONE, new NoneMethodDataInterceptorHandler());
            this.put(Mode.PROFILE, new ProfileMethodDataInterceptorHandler());
            this.put(Mode.TEST, new TestMethodDataInterceptorHandler());
            this.put(Mode.SERIALIZE, new SerializeMethodDataInterceptorHandler());
            this.put(Mode.TRANSFORM, new TransformMethodDataInterceptorHandler());
        }
    });

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.modeMethodDataInterceptorHandlerMap.containsKey((Object)ProfileRepository.getRequestMode())) {
            return this.modeMethodDataInterceptorHandlerMap.get((Object)ProfileRepository.getRequestMode()).handle(invocation);
        }
        return invocation.proceed();
    }
}

