/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.compare.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.compare.TestCompareException;
import com.flipkart.compare.diff.DiffDetail;
import com.flipkart.compare.diff.DiffIgnoreRepository;
import com.flipkart.compare.diff.DiffType;
import com.google.inject.Inject;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestCompareHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCompareHandler.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Inject
    private static DiffIgnoreRepository diffIgnoreRepository;

    public final void compare(byte[] profiledData, byte[] testData) throws TestCompareException {
        try {
            this.doCompare(profiledData, testData);
        }
        catch (TestCompareException e) {
            List<DiffDetail> diffDetails = e.getDiffs();
            if (diffDetails != null && !diffDetails.isEmpty()) {
                for (DiffDetail diffDetail : diffDetails) {
                    String diffPathForIgnoreRule = diffDetail.getDiffPath();
                    LOGGER.debug("not ignored DiffDetail | DiffType: " + (Object)((Object)diffDetail.getDiffType()) + " | suggested ignore pattern | " + diffPathForIgnoreRule.replaceAll(", \"[a-zA-Z0-9_-]*\",", ", (.*),"));
                }
            }
            String diffsString = null;
            try {
                diffsString = OBJECT_MAPPER.writeValueAsString(diffDetails);
            }
            catch (JsonProcessingException e1) {
                LOGGER.error("error serializing diffs.");
            }
            LOGGER.error("non-ignorable diff present: " + diffsString, diffDetails);
            throw new TestCompareException("non-ignorable diff present: " + diffsString, diffDetails);
        }
    }

    protected abstract void doCompare(byte[] var1, byte[] var2) throws TestCompareException;

    public final boolean canBeIgnored(DiffDetail diffDetail) {
        String diffPathForIgnoreRule = diffDetail.getDiffPath();
        if (diffDetail.getDiffType().equals((Object)DiffType.ADD) && diffIgnoreRepository.getDiffIgnorePatterns().containsKey((Object)DiffType.ADD)) {
            for (Pattern pattern : diffIgnoreRepository.getDiffIgnorePatterns().get((Object)DiffType.ADD)) {
                if (!pattern.matcher(diffPathForIgnoreRule).matches()) continue;
                return true;
            }
        }
        if (diffDetail.getDiffType().equals((Object)DiffType.MOVE) && diffIgnoreRepository.getDiffIgnorePatterns().containsKey((Object)DiffType.MOVE)) {
            for (Pattern pattern : diffIgnoreRepository.getDiffIgnorePatterns().get((Object)DiffType.MOVE)) {
                if (!pattern.matcher(diffPathForIgnoreRule).matches()) continue;
                return true;
            }
        }
        if (diffDetail.getDiffType().equals((Object)DiffType.REMOVE) && diffIgnoreRepository.getDiffIgnorePatterns().containsKey((Object)DiffType.REMOVE)) {
            for (Pattern pattern : diffIgnoreRepository.getDiffIgnorePatterns().get((Object)DiffType.REMOVE)) {
                if (!pattern.matcher(diffPathForIgnoreRule).matches()) continue;
                return true;
            }
        }
        if (diffDetail.getDiffType().equals((Object)DiffType.MODIFY) && diffIgnoreRepository.getDiffIgnorePatterns().containsKey((Object)DiffType.MODIFY)) {
            for (Pattern pattern : diffIgnoreRepository.getDiffIgnorePatterns().get((Object)DiffType.MODIFY)) {
                if (!pattern.matcher(diffPathForIgnoreRule).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public final DiffDetail getDiffDetail(String diffKey, Object expected, Object actual, DiffType diffType) {
        DiffDetail diffDetail;
        DiffDetail.Builder diffDetailBuilder = DiffDetail.builder().setDiffPath(diffKey).setActualValue(actual).setExpectedValue(expected).setDiffType(diffType);
        if (actual == null && expected != null) {
            diffDetailBuilder.setDiffType(DiffType.REMOVE);
        }
        if (actual != null && expected == null) {
            diffDetailBuilder.setDiffType(DiffType.ADD);
        }
        if (this.canBeIgnored(diffDetail = diffDetailBuilder.build())) {
            return null;
        }
        return diffDetail;
    }
}

