/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client;

import com.flipkart.foxtrot.client.ClientType;
import com.flipkart.foxtrot.client.Document;
import com.flipkart.foxtrot.client.EventSender;
import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.FoxtrotCluster;
import com.flipkart.foxtrot.client.selectors.MemberSelector;
import com.flipkart.foxtrot.client.selectors.RandomSelector;
import com.flipkart.foxtrot.client.senders.HttpAsyncEventSender;
import com.flipkart.foxtrot.client.senders.HttpSyncEventSender;
import com.flipkart.foxtrot.client.senders.QueuedSender;
import com.flipkart.foxtrot.client.serialization.EventSerializationHandler;
import com.flipkart.foxtrot.client.serialization.JacksonJsonSerializationHandler;
import com.flipkart.foxtrot.client.util.TypeChecker;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FoxtrotClient {
    private final FoxtrotCluster foxtrotCluster;
    private final EventSender eventSender;

    public FoxtrotClient(FoxtrotClientConfig config) throws Exception {
        this(config, new RandomSelector(), JacksonJsonSerializationHandler.INSTANCE);
    }

    public FoxtrotClient(FoxtrotClientConfig config, MemberSelector memberSelector, EventSerializationHandler serializationHandler) throws Exception {
        this.foxtrotCluster = new FoxtrotCluster(config, memberSelector);
        Preconditions.checkNotNull((Object)config.getTable());
        Preconditions.checkNotNull((Object)((Object)config.getClientType()));
        Preconditions.checkNotNull((Object)config.getHost());
        Preconditions.checkArgument((config.getPort() >= 80 ? 1 : 0) != 0);
        switch (config.getClientType()) {
            case sync: {
                this.eventSender = new HttpSyncEventSender(config, this.foxtrotCluster, serializationHandler);
                break;
            }
            case async: {
                this.eventSender = new HttpAsyncEventSender(config, this.foxtrotCluster, serializationHandler);
                break;
            }
            case queued: {
                ArrayList<String> messages = new ArrayList<String>();
                if (StringUtils.isEmpty((CharSequence)config.getQueuePath())) {
                    messages.add(String.format("table=%s empty_local_queue_path", config.getTable()));
                }
                if (config.getBatchSize() <= 1) {
                    messages.add(String.format("table=%s invalid_batchSize must_be_greater_than_1", config.getTable()));
                }
                if (!messages.isEmpty()) {
                    throw new Exception(((Object)messages).toString());
                }
                this.eventSender = new QueuedSender(new HttpSyncEventSender(config, this.foxtrotCluster, serializationHandler), serializationHandler, config.getQueuePath(), config.getBatchSize());
                break;
            }
            default: {
                throw new Exception(String.format("table=%s invalid_client_type type_provided=%s allowed_types=%s", new Object[]{config.getTable(), config.getClientType(), StringUtils.join((Object[])ClientType.values(), (String)",")}));
            }
        }
    }

    public FoxtrotClient(FoxtrotCluster foxtrotCluster, EventSender eventSender) {
        this.foxtrotCluster = foxtrotCluster;
        this.eventSender = eventSender;
    }

    public void send(Document document) throws Exception {
        Preconditions.checkNotNull((Object)document.getData());
        Preconditions.checkArgument((!TypeChecker.isPrimitive(document.getData()) ? 1 : 0) != 0);
        this.eventSender.send(document);
    }

    public void send(String tableName, Document document) throws Exception {
        Preconditions.checkNotNull((Object)document.getData());
        Preconditions.checkArgument((!TypeChecker.isPrimitive(document.getData()) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)tableName);
        this.eventSender.send(tableName, document);
    }

    public void send(String tableName, List<Document> documents) throws Exception {
        Preconditions.checkNotNull((Object)tableName);
        this.eventSender.send(tableName, documents);
    }

    public void send(List<Document> documents) throws Exception {
        this.eventSender.send(documents);
    }

    void close() throws Exception {
        this.eventSender.close();
        this.foxtrotCluster.stop();
    }
}

