/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.senders.impl;

import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    private static final Logger logger = LoggerFactory.getLogger(CustomKeepAliveStrategy.class);
    private final FoxtrotClientConfig config;

    public CustomKeepAliveStrategy(FoxtrotClientConfig config) {
        this.config = config;
    }

    public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(httpResponse.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                long timeoutSeconds = Long.parseLong(value);
                logger.info("Setting keep alive to: {} seconds", (Object)timeoutSeconds);
                return timeoutSeconds * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        logger.debug("Did not get a keep alive from server");
        logger.debug("Setting keep alive to: {} seconds", (Object)(this.config.getKeepAliveTimeMillis() / 1000L));
        return this.config.getKeepAliveTimeMillis();
    }
}

