/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.cluster;

import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterStatus;
import com.flipkart.foxtrot.client.senders.impl.CustomKeepAliveStrategy;
import com.flipkart.foxtrot.client.serialization.FoxtrotClusterResponseSerializationHandler;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStatusUpdater
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)ClusterStatusUpdater.class.getSimpleName());
    private final CloseableHttpClient httpClient;
    private AtomicReference<FoxtrotClusterStatus> status;
    private final URI uri;
    private final FoxtrotClusterResponseSerializationHandler serializationHandler;

    private ClusterStatusUpdater(AtomicReference<FoxtrotClusterStatus> status, CloseableHttpClient httpClient, FoxtrotClusterResponseSerializationHandler serializationHandler, URI uri) {
        this.status = status;
        this.httpClient = httpClient;
        this.uri = uri;
        this.serializationHandler = serializationHandler;
    }

    public static ClusterStatusUpdater create(FoxtrotClientConfig config, AtomicReference<FoxtrotClusterStatus> status, FoxtrotClusterResponseSerializationHandler serializationHandler) throws Exception {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(config.getHost(), config.getPort())), config.getMaxConnections());
        CloseableHttpClient httpClient = HttpClients.custom().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new CustomKeepAliveStrategy(config)).evictExpiredConnections().evictIdleConnections(5L, TimeUnit.SECONDS).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        return new ClusterStatusUpdater(status, httpClient, serializationHandler, new URIBuilder().setHost(config.getHost()).setPort(config.getPort()).setPath("/foxtrot/v1/cluster/members").setScheme("http").build());
    }

    @Override
    public void run() {
        this.loadClusterData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadClusterData() {
        CloseableHttpResponse response = null;
        try {
            logger.trace("Initiating data get");
            HttpGet httpGet = new HttpGet(this.uri);
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                logger.error("Error getting status: ", (Object)response.getStatusLine().getReasonPhrase());
                return;
            }
            HttpEntity entity = response.getEntity();
            byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
            logger.debug("Received data: {}", (Object)new String(data));
            FoxtrotClusterStatus foxtrotClusterStatus = this.serializationHandler.deserialize(data);
            this.status.set(foxtrotClusterStatus);
        }
        catch (Exception e) {
            logger.error("Error getting cluster data: ", (Throwable)e);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("Error closing connection: ", (Throwable)e);
                }
            }
        }
    }
}

