/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client;

import com.flipkart.foxtrot.client.Document;
import com.flipkart.foxtrot.client.EventSender;
import com.flipkart.foxtrot.client.EventSerializationHandler;
import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.MemberSelector;
import com.flipkart.foxtrot.client.cluster.FoxtrotCluster;
import com.flipkart.foxtrot.client.selectors.RandomSelector;
import com.flipkart.foxtrot.client.senders.HttpAsyncEventSender;
import com.flipkart.foxtrot.client.senders.HttpSyncEventSender;
import com.flipkart.foxtrot.client.senders.QueuedSender;
import com.flipkart.foxtrot.client.serialization.JacksonJsonFoxtrotClusterResponseSerializationHandlerImpl;
import com.flipkart.foxtrot.client.serialization.JacksonJsonSerializationHandler;
import com.flipkart.foxtrot.client.util.TypeChecker;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;

public class FoxtrotClient {
    private final FoxtrotCluster foxtrotCluster;
    private final EventSender eventSender;

    public FoxtrotClient(FoxtrotClientConfig config) throws Exception {
        this(config, new RandomSelector(), JacksonJsonSerializationHandler.INSTANCE);
    }

    public FoxtrotClient(FoxtrotClientConfig config, MemberSelector memberSelector, EventSerializationHandler serializationHandler) throws Exception {
        this.foxtrotCluster = new FoxtrotCluster(config, memberSelector, JacksonJsonFoxtrotClusterResponseSerializationHandlerImpl.INSTANCE);
        this.eventSender = Strings.isNullOrEmpty((String)config.getLocalQueuePath()) ? new HttpAsyncEventSender(config, this.foxtrotCluster, serializationHandler) : new QueuedSender(new HttpSyncEventSender(config, this.foxtrotCluster, serializationHandler), serializationHandler, config.getLocalQueuePath(), config.getBatchSize(), config.getRefreshIntervalSecs());
    }

    public FoxtrotClient(FoxtrotCluster foxtrotCluster, EventSender eventSender) {
        this.foxtrotCluster = foxtrotCluster;
        this.eventSender = eventSender;
    }

    public void send(Document document) throws Exception {
        Preconditions.checkNotNull((Object)document.getData());
        Preconditions.checkArgument((!TypeChecker.isPrimitive(document.getData()) ? 1 : 0) != 0);
        this.eventSender.send(document);
    }

    public void send(List<Document> documents) throws Exception {
        this.eventSender.send(documents);
    }

    public void close() throws Exception {
        this.eventSender.close();
        this.foxtrotCluster.stop();
    }
}

