/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import com.flipkart.flux.api.VersionedEventData;
import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.impl.task.AbstractTask;
import com.flipkart.flux.impl.task.SerializedEvent;
import com.flipkart.flux.registry.TaskExecutableImpl;
import com.flipkart.flux.utils.Pair;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalJvmTask
extends AbstractTask {
    private final Executable toInvoke;
    private static final Logger logger = LogManager.getLogger(LocalJvmTask.class);

    public LocalJvmTask(Executable toInvoke) {
        this.toInvoke = toInvoke;
    }

    @Override
    public String getName() {
        return this.toInvoke.getName();
    }

    @Override
    public String getTaskGroupName() {
        return "flux";
    }

    @Override
    public int getExecutionConcurrency() {
        return ((TaskExecutableImpl)this.toInvoke).getExecutionConcurrency();
    }

    @Override
    public int getExecutionTimeout() {
        return (int)this.toInvoke.getTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Object, FluxError> execute(VersionedEventData[] events) {
        Object[] parameters = new Object[events.length];
        Class[] parameterTypes = this.toInvoke.getParameterTypes();
        try {
            URLClassLoader classLoader = ((TaskExecutableImpl)this.toInvoke).getDeploymentUnitClassLoader();
            Object objectMapperInstance = ((TaskExecutableImpl)this.toInvoke).getObjectMapperInstance();
            Class<?> objectMapper = objectMapperInstance.getClass();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (events[i].getData() == null) continue;
                if (parameterTypes[i].isAssignableFrom(Class.forName(events[i].getType(), true, classLoader))) {
                    parameters[i] = objectMapper.getMethod("readValue", String.class, Class.class).invoke(objectMapperInstance, events[i].getData(), Class.forName(events[i].getType(), true, classLoader));
                    continue;
                }
                logger.warn("Parameter type {} did not match with event: {}", (Object)parameterTypes[i], (Object)events[i]);
                throw new RuntimeException("Parameter type " + parameterTypes[i] + " did not match with event: " + events[i]);
            }
            Method writeValueAsString = objectMapper.getMethod("writeValueAsString", Object.class);
            SerializedEvent serializedEvent = null;
            try {
                Thread.currentThread().setContextClassLoader(((TaskExecutableImpl)this.toInvoke).getDeploymentUnitClassLoader());
                Object returnObject = this.toInvoke.execute(parameters);
                if (returnObject != null) {
                    serializedEvent = new SerializedEvent(returnObject.getClass().getCanonicalName(), (String)writeValueAsString.invoke(objectMapperInstance, returnObject));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            return new Pair(serializedEvent, null);
        }
        catch (Exception e) {
            logger.error("Bad things happened while trying to execute {}", (Object)this.toInvoke, (Object)e);
            return new Pair(null, (Object)new FluxError(FluxError.ErrorType.runtime, e.getMessage(), e));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalJvmTask that = (LocalJvmTask)o;
        return this.toInvoke.equals(that.toInvoke);
    }

    public int hashCode() {
        return this.toInvoke.hashCode();
    }
}

