/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.eventscheduler;

import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.flipkart.flux.eventscheduler.service.EventSchedulerService;
import javax.inject.Inject;
import scala.Option;

public class AkkaEventSchedulerService
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final EventSchedulerService eventSchedulerService;

    @Inject
    public AkkaEventSchedulerService(EventSchedulerService eventSchedulerService) {
        this.eventSchedulerService = eventSchedulerService;
    }

    public void preStart() throws Exception {
        this.logger.info("Starting Event scheduler service");
        if (!this.eventSchedulerService.isRunning().booleanValue()) {
            this.eventSchedulerService.start();
        }
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
    }

    public void postRestart(Throwable reason) throws Exception {
    }

    public void postStop() throws Exception {
        this.logger.info("Stopping Event scheduler service");
        if (this.eventSchedulerService.isRunning().booleanValue()) {
            this.eventSchedulerService.stop();
        }
    }

    public void onReceive(Object message) throws Exception {
        this.logger.info("EventSchedulerService Actor received message: {}", message);
        this.unhandled(message);
    }
}

