/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task.registry;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.routing.RoundRobinPool;
import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.task.AkkaTask;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.polyguice.core.Initializable;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

@Singleton
public class EagerInitRouterRegistryImpl
implements RouterRegistry,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(EagerInitRouterRegistryImpl.class);
    private ActorSystemManager actorSystemManager;
    private Map<String, Integer> routerConfigMap;
    private final HashMap<String, ActorRef> routerMap = new HashMap();
    private int maxTaskActorCreateRetries;

    @Inject
    public EagerInitRouterRegistryImpl(ActorSystemManager actorSystemManager, @Named(value="runtime.actorsystem.maxTaskActorCreateRetries") int maxTaskActorCreateRetries, @Named(value="routerConfigMap") Map<String, Integer> routerConfigMap) {
        this.actorSystemManager = actorSystemManager;
        this.maxTaskActorCreateRetries = maxTaskActorCreateRetries;
        this.routerConfigMap = routerConfigMap;
    }

    @Override
    public ActorRef getRouter(String forWorker) {
        return this.routerMap.get(forWorker);
    }

    public void initialize() {
        ActorSystem actorSystem = this.actorSystemManager.retrieveActorSystem();
        for (Map.Entry<String, Integer> routerConfig : this.routerConfigMap.entrySet()) {
            String routerName = routerConfig.getKey();
            Integer noOfActors = routerConfig.getValue();
            ActorRef router = actorSystem.actorOf(new RoundRobinPool(noOfActors.intValue()).withSupervisorStrategy(this.getTasksuperviseStrategy()).props(Props.create(AkkaTask.class, (Object[])new Object[0])), routerName);
            this.routerMap.put(routerName, router);
            logger.info("Created router: {} with no.of actors: {}", (Object)routerName, (Object)noOfActors);
        }
    }

    private SupervisorStrategy getTasksuperviseStrategy() {
        return new OneForOneStrategy(this.maxTaskActorCreateRetries, (Duration)Duration.Inf(), t -> {
            if (t instanceof RuntimeException) {
                return SupervisorStrategy.restart();
            }
            return SupervisorStrategy.escalate();
        });
    }
}

