/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task.registry;

import akka.cluster.routing.ClusterRouterPoolSettings;
import com.flipkart.flux.impl.task.registry.ConfigurationException;
import com.flipkart.flux.impl.task.registry.RouterConfigurationRegistry;
import com.flipkart.polyguice.core.ConfigurationProvider;
import com.flipkart.polyguice.core.Initializable;
import java.util.HashSet;
import java.util.Set;
import javafx.util.Pair;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

@Singleton
public class LocalRouterConfigurationRegistryImpl
implements RouterConfigurationRegistry,
Initializable {
    private static final Logger log = LoggerFactory.getLogger(LocalRouterConfigurationRegistryImpl.class);
    Set<String> routerNames;
    ConfigurationProvider configurationProvider;
    private Integer defaultTotalInstances;
    private Integer defaultMaxInstancesPerNode;

    LocalRouterConfigurationRegistryImpl() {
    }

    @Inject
    public LocalRouterConfigurationRegistryImpl(@Named(value="routerNames") Set<String> routerNames, ConfigurationProvider configurationProvider) {
        this();
        this.routerNames = routerNames;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public Iterable<Pair<String, ClusterRouterPoolSettings>> getConfigurations() {
        HashSet<Pair<String, ClusterRouterPoolSettings>> routerSettings = new HashSet<Pair<String, ClusterRouterPoolSettings>>();
        this.routerNames.forEach(rName -> {
            Integer totalInstances = (Integer)this.configurationProvider.getValue("routers." + rName + ".totalInstances", Integer.class);
            Integer maxInstances = (Integer)this.configurationProvider.getValue("routers." + rName + ".maxInstancesPerNode", Integer.class);
            if (totalInstances == null || maxInstances == null) {
                log.info("Could not find settings for router {}, going with default settings", rName);
                totalInstances = this.defaultTotalInstances;
                maxInstances = this.defaultMaxInstancesPerNode;
            }
            routerSettings.add(new Pair(rName, (Object)new ClusterRouterPoolSettings(totalInstances.intValue(), maxInstances.intValue(), true, Option.empty())));
        });
        return routerSettings;
    }

    public void initialize() {
        this.defaultTotalInstances = (Integer)this.configurationProvider.getValue("routers.default.totalInstances", Integer.class);
        this.defaultMaxInstancesPerNode = (Integer)this.configurationProvider.getValue("routers.default.maxInstancesPerNode", Integer.class);
        if (this.defaultMaxInstancesPerNode == null || this.defaultTotalInstances == null) {
            throw new ConfigurationException("Could not find default router configurations!!");
        }
    }
}

