/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.impl.task.AbstractTask;
import com.flipkart.flux.impl.task.SerializedEvent;
import com.flipkart.flux.registry.TaskExecutableImpl;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJvmTask
extends AbstractTask {
    private final Executable toInvoke;
    private static final Logger logger = LoggerFactory.getLogger(LocalJvmTask.class);

    public LocalJvmTask(Executable toInvoke) {
        this.toInvoke = toInvoke;
    }

    @Override
    public String getName() {
        return this.toInvoke.getName();
    }

    @Override
    public String getTaskGroupName() {
        return "flux";
    }

    @Override
    public int getExecutionConcurrency() {
        return 10;
    }

    @Override
    public int getExecutionTimeout() {
        return (int)this.toInvoke.getTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Object, FluxError> execute(EventData[] events) {
        Object[] parameters = new Object[events.length];
        Class[] parameterTypes = this.toInvoke.getParameterTypes();
        try {
            URLClassLoader classLoader = ((TaskExecutableImpl)this.toInvoke).getDeploymentUnitClassLoader();
            Object objectMapperInstance = ((TaskExecutableImpl)this.toInvoke).getObjectMapperInstance();
            Class<?> objectMapper = objectMapperInstance.getClass();
            for (int i = 0; i < parameterTypes.length; ++i) {
                for (EventData anEvent : events) {
                    if (!Class.forName(anEvent.getType(), true, classLoader).equals(parameterTypes[i])) continue;
                    parameters[i] = objectMapper.getMethod("readValue", String.class, Class.class).invoke(objectMapperInstance, anEvent.getData(), Class.forName(anEvent.getType(), true, classLoader));
                }
                if (parameters[i] != null) continue;
                logger.warn("Could not find a paramter of type {} in event list {}", (Object)parameterTypes[i], (Object)events);
                throw new RuntimeException("Could not find a paramter of type " + parameterTypes[i]);
            }
            Method writeValueAsString = objectMapper.getMethod("writeValueAsString", Object.class);
            SerializedEvent serializedEvent = null;
            try {
                Thread.currentThread().setContextClassLoader(((TaskExecutableImpl)this.toInvoke).getDeploymentUnitClassLoader());
                Object returnObject = this.toInvoke.execute(parameters);
                if (returnObject != null) {
                    serializedEvent = new SerializedEvent(returnObject.getClass().getCanonicalName(), (String)writeValueAsString.invoke(objectMapperInstance, returnObject));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            return new Pair(serializedEvent, null);
        }
        catch (Exception e) {
            logger.error("Bad things happened while trying to execute {}", (Object)this.toInvoke, (Object)e);
            return new Pair(null, (Object)new FluxError(FluxError.ErrorType.runtime, e.getMessage(), e));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalJvmTask that = (LocalJvmTask)o;
        return this.toInvoke.equals(that.toInvoke);
    }

    public int hashCode() {
        return this.toInvoke.hashCode();
    }
}

