/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.redriver;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.cluster.singleton.ClusterSingletonManager;
import akka.cluster.singleton.ClusterSingletonManagerSettings;
import akka.cluster.singleton.ClusterSingletonProxy;
import akka.cluster.singleton.ClusterSingletonProxySettings;
import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.message.TaskRedriverDetails;
import com.flipkart.flux.impl.redriver.AkkaRedriverTask;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.flipkart.polyguice.core.Initializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class AkkaRedriverRegistryImpl
implements RedriverRegistry,
Initializable {
    private ActorSystemManager actorSystemManager;
    private int noOfRedriverWorkers;
    private ActorRef redriverActorProxy;

    @Inject
    public AkkaRedriverRegistryImpl(ActorSystemManager actorSystemManager, @Named(value="runtime.actorsystem.noOfRedriverWorkers") int noOfRedriverWorkers) {
        this.actorSystemManager = actorSystemManager;
        this.noOfRedriverWorkers = noOfRedriverWorkers;
    }

    public void initialize() {
        ActorSystem actorSystem = this.actorSystemManager.retrieveActorSystem();
        ClusterSingletonManagerSettings settings = ClusterSingletonManagerSettings.create((ActorSystem)actorSystem);
        actorSystem.actorOf(ClusterSingletonManager.props((Props)Props.create(AkkaRedriverTask.class, (Object[])new Object[]{this.noOfRedriverWorkers}), (Object)PoisonPill.getInstance(), (ClusterSingletonManagerSettings)settings), "redriverActor");
        ClusterSingletonProxySettings proxySettings = ClusterSingletonProxySettings.create((ActorSystem)actorSystem);
        this.redriverActorProxy = actorSystem.actorOf(ClusterSingletonProxy.props((String)"/user/redriverActor", (ClusterSingletonProxySettings)proxySettings), "redriverActorProxy");
    }

    public void registerTask(Long taskId, long redriverDelay) {
        this.redriverActorProxy.tell((Object)new TaskRedriverDetails(taskId, redriverDelay, TaskRedriverDetails.RegisterAction.Register), ActorRef.noSender());
    }

    public void deRegisterTask(Long taskId) {
        this.redriverActorProxy.tell((Object)new TaskRedriverDetails(taskId, TaskRedriverDetails.RegisterAction.Deregister), ActorRef.noSender());
    }

    public void redriveTask(Long taskId) {
        this.redriverActorProxy.tell((Object)new TaskRedriverDetails(taskId, TaskRedriverDetails.RegisterAction.Redrive), ActorRef.noSender());
    }
}

