/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.api.core.Task;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.impl.task.AbstractTask;
import com.flipkart.flux.impl.task.SerializedEvent;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import javafx.util.Pair;

public class TaskExecutor
extends HystrixCommand<Event> {
    public static final String MANAGED_RUNTIME = "managedRuntime";
    private Task task;
    private EventData[] events;
    private final Long stateMachineId;
    private final String outputeEventName;

    public TaskExecutor(AbstractTask task, EventData[] events, Long stateMachineId, String outputeEventName) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)task.getTaskGroupName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)task.getName())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)(task.getName() + "-TP"))).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(task.getExecutionConcurrency())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionTimeoutInMilliseconds(task.getExecutionTimeout())));
        this.task = task;
        this.events = events;
        this.stateMachineId = stateMachineId;
        this.outputeEventName = outputeEventName;
    }

    protected Event run() throws Exception {
        Pair<Object, FluxError> result = this.task.execute(this.events);
        if (result.getValue() != null) {
            throw (FluxError)result.getValue();
        }
        SerializedEvent returnObject = (SerializedEvent)result.getKey();
        if (returnObject != null) {
            return new Event(this.outputeEventName, returnObject.getEventType(), Event.EventStatus.triggered, this.stateMachineId, returnObject.getSerializedEventData(), MANAGED_RUNTIME);
        }
        return null;
    }
}

