/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task.registry;

import akka.cluster.routing.ClusterRouterPoolSettings;
import com.flipkart.flux.impl.task.registry.ConfigurationException;
import com.flipkart.flux.impl.task.registry.LocalRouterConfigurationRegistryImpl;
import com.flipkart.polyguice.core.ConfigurationProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.util.Pair;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import scala.Option;

public class LocalRouterConfigurationRegistryImplTest {
    @Test
    public void testGetConfigurations_shouldReadConfigsFromConfigProvider() throws Exception {
        LocalRouterConfigurationRegistryImpl localRouterConfigurationRegistry = new LocalRouterConfigurationRegistryImpl((Set)new HashSet<String>(){
            {
                this.add("foo");
            }
        }, this.setupConfigProvider((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("routers.foo.totalInstances", 1);
                this.put("routers.foo.maxInstancesPerNode", 1);
            }
        }));
        Assertions.assertThat((Iterable)localRouterConfigurationRegistry.getConfigurations()).containsExactly((Object[])new Pair[]{new Pair((Object)"foo", (Object)new ClusterRouterPoolSettings(1, 1, true, Option.empty()))});
    }

    @Test
    public void testGetConfigurations_shouldUseDefaultConfigurationsIfNotExplicitlyProvided() throws Exception {
        LocalRouterConfigurationRegistryImpl localRouterConfigurationRegistry = new LocalRouterConfigurationRegistryImpl((Set)new HashSet<String>(){
            {
                this.add("foo");
            }
        }, this.setupConfigProvider((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("routers.default.totalInstances", 1);
                this.put("routers.default.maxInstancesPerNode", 1);
            }
        }));
        localRouterConfigurationRegistry.initialize();
        Assertions.assertThat((Iterable)localRouterConfigurationRegistry.getConfigurations()).containsExactly((Object[])new Pair[]{new Pair((Object)"foo", (Object)new ClusterRouterPoolSettings(1, 1, true, Option.empty()))});
    }

    @Test(expected=ConfigurationException.class)
    public void testInit_shouldBombIfDefaultConfigsNotPresent() throws Exception {
        LocalRouterConfigurationRegistryImpl localRouterConfigurationRegistry = new LocalRouterConfigurationRegistryImpl((Set)new HashSet<String>(){
            {
                this.add("foo");
            }
        }, this.setupConfigProvider((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("routers.foo.totalInstances", 1);
                this.put("routers.foo.maxInstancesPerNode", 1);
            }
        }));
        localRouterConfigurationRegistry.initialize();
    }

    private ConfigurationProvider setupConfigProvider(final Map<String, Object> configMap) {
        return new ConfigurationProvider(){

            public boolean contains(String s) {
                return configMap.containsKey(s);
            }

            public Object getValue(String s, Class<?> aClass) {
                return configMap.get(s);
            }
        };
    }
}

