/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.FluxError;
import com.flipkart.flux.domain.Task;
import com.flipkart.flux.impl.task.AbstractTask;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import javafx.util.Pair;

public class TaskExecutor
extends HystrixCommand<Event> {
    public static final String MANAGED_RUNTIME = "managedRuntime";
    private Task task;
    private Event[] events;
    private final Long stateMachineId;
    private final String outputeEventName;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public TaskExecutor(AbstractTask task, Event[] events, Long stateMachineId, String outputeEventName) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)task.getTaskGroupName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)task.getName())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)(String.valueOf(task.getName()) + "-TP"))).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(task.getExecutionConcurrency())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionTimeoutInMilliseconds(task.getExecutionTimeout())));
        this.task = task;
        this.events = events;
        this.stateMachineId = stateMachineId;
        this.outputeEventName = outputeEventName;
    }

    protected Event run() throws Exception {
        Pair result = this.task.execute(this.events);
        if (result.getValue() != null) {
            throw (FluxError)result.getValue();
        }
        Object returnObject = result.getKey();
        if (returnObject != null) {
            return new Event(this.outputeEventName, returnObject.getClass().getCanonicalName(), Event.EventStatus.triggered, this.stateMachineId, objectMapper.writeValueAsString(returnObject), MANAGED_RUNTIME);
        }
        return null;
    }
}

