/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.clientelb.dao;

import com.flipkart.flux.clientelb.dao.iface.ClientElbDAO;
import com.flipkart.flux.domain.ClientElb;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.google.inject.name.Named;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ClientElbDAOImpl
implements ClientElbDAO {
    private SessionFactoryContext sessionFactoryContext;

    @Inject
    public ClientElbDAOImpl(@Named(value="schedulerSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        this.sessionFactoryContext = sessionFactoryContext;
    }

    @Override
    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public ClientElb create(ClientElb clientElb) {
        this.currentSession().save((Object)clientElb);
        return clientElb;
    }

    @Override
    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public ClientElb findById(String id) {
        Criteria criteria = this.currentSession().createCriteria(ClientElb.class).add((Criterion)Restrictions.eq((String)"id", (Object)id));
        Object object = criteria.uniqueResult();
        ClientElb castedObject = null;
        if (object != null) {
            castedObject = (ClientElb)object;
        }
        return castedObject;
    }

    @Override
    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public void updateElbUrl(String clientElbId, String clientElbUrl) {
        Query updateQuery = this.currentSession().createQuery("update ClientElb set elbUrl = :clientElbUrl where id = :clientElbId");
        updateQuery.setString("clientElbUrl", clientElbUrl.toString());
        updateQuery.setString("clientElbId", clientElbId);
        updateQuery.executeUpdate();
    }

    @Override
    @Transactional
    @SelectDataSource(storage=Storage.SCHEDULER)
    public void delete(String id) {
        Query deleteQuery = this.currentSession().createQuery("delete ClientElb c where c.id=:id");
        deleteQuery.setString("id", id);
        deleteQuery.executeUpdate();
    }

    public Session currentSession() {
        return this.sessionFactoryContext.getThreadLocalSession();
    }
}

