/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.module;

import com.flipkart.flux.eventscheduler.dao.EventSchedulerDao;
import com.flipkart.flux.eventscheduler.model.ScheduledEvent;
import com.flipkart.flux.guice.interceptor.TransactionInterceptor;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.impl.SessionFactoryContextImpl;
import com.flipkart.flux.redriver.dao.MessageDao;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.configuration.Configuration;
import org.hibernate.SessionFactory;

public class SchedulerModule
extends AbstractModule {
    private static final String FLUX_SCHEDULER_HIBERNATE_CONFIG_NAME_SPACE = "flux_scheduler.Hibernate";

    protected void configure() {
        Provider provider = this.getProvider(Key.get(SessionFactoryContext.class, (Annotation)Names.named((String)"schedulerSessionFactoryContext")));
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor((javax.inject.Provider)provider);
        this.bindInterceptor(Matchers.inPackage((Package)MessageDao.class.getPackage()), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionInterceptor});
        this.bindInterceptor(Matchers.inPackage((Package)EventSchedulerDao.class.getPackage()), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionInterceptor});
    }

    @Provides
    @Singleton
    @Named(value="schedulerHibernateConfiguration")
    public org.hibernate.cfg.Configuration getConfiguration(YamlConfiguration yamlConfiguration) {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        this.addAnnotatedClassesAndTypes(configuration);
        Configuration hibernateConfig = yamlConfiguration.subset(FLUX_SCHEDULER_HIBERNATE_CONFIG_NAME_SPACE);
        Iterator propertyKeys = hibernateConfig.getKeys();
        Properties configProperties = new Properties();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            Object propertyValue = hibernateConfig.getProperty(propertyKey);
            configProperties.put(propertyKey, propertyValue);
        }
        configuration.addProperties(configProperties);
        return configuration;
    }

    @Provides
    @Singleton
    @Named(value="schedulerSessionFactoryContext")
    public SessionFactoryContext getSessionFactoryProvider(@Named(value="schedulerHibernateConfiguration") org.hibernate.cfg.Configuration configuration) {
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        HashMap<DataSourceType, SessionFactory> map = new HashMap<DataSourceType, SessionFactory>();
        map.put(DataSourceType.READ_WRITE, sessionFactory);
        return new SessionFactoryContextImpl(map, DataSourceType.READ_WRITE);
    }

    private void addAnnotatedClassesAndTypes(org.hibernate.cfg.Configuration configuration) {
        configuration.addAnnotatedClass(ScheduledMessage.class);
        configuration.addAnnotatedClass(ScheduledEvent.class);
    }
}

