/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventAndExecutionData;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.api.VersionedEventData;
import com.flipkart.flux.client.runtime.EventProxyConnector;
import com.flipkart.flux.controller.WorkFlowExecutionController;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateMachineStatus;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.CreateStateMachineException;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.metrics.iface.MetricsClient;
import com.flipkart.flux.persistence.AuditEntityManager;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.StateMachineEntityManager;
import com.flipkart.flux.persistence.StateMachineExecutionEntitiesManager;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.dao.iface.AuditDAO;
import com.flipkart.flux.persistence.dao.iface.EventsDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.persistence.dao.impl.ParallelScatterGatherQueryHelper;
import com.flipkart.flux.persistence.key.FSMId;
import com.flipkart.flux.representation.IllegalRepresentationException;
import com.flipkart.flux.resource.FsmGraph;
import com.flipkart.flux.resource.FsmGraphEdge;
import com.flipkart.flux.resource.FsmGraphVertex;
import com.flipkart.flux.task.eventscheduler.EventSchedulerRegistry;
import com.flipkart.flux.utils.LoggingUtils;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;

@Singleton
@Path(value="/api/machines")
@Named
public class StateMachineResource {
    private static final String TRIGGER = " ";
    private static final String CORRELATION_ID = "correlationId";
    private static final Logger logger = LogManager.getLogger(StateMachineResource.class);
    private WorkFlowExecutionController workFlowExecutionController;
    private StateMachinesDAO stateMachinesDAO;
    private StateMachineEntityManager smEntityManager;
    private StateMachineExecutionEntitiesManager smExecutionEntitiesManager;
    private StatesDAO statesDAO;
    private EventsDAO eventsDAO;
    private AuditDAO auditDAO;
    private AuditEntityManager auditEntityManager;
    private EventSchedulerRegistry eventSchedulerRegistry;
    private ObjectMapper objectMapper;
    private MetricsClient metricsClient;
    private ParallelScatterGatherQueryHelper parallelScatterGatherQueryHelper;
    private EventProxyConnector eventProxyConnector;
    private String eventProxyEnabled;
    private StateTraversalPathDAO stateTraversalPathDAO;

    @Inject
    public StateMachineResource(EventsDAO eventsDAO, AuditDAO auditDAO, AuditEntityManager auditEntityManager, StateMachinesDAO stateMachinesDAO, StateMachineEntityManager smEntityManager, StateMachineExecutionEntitiesManager smExecutionEntitiesManager, StatesDAO statesDAO, WorkFlowExecutionController workFlowExecutionController, MetricsClient metricsClient, ParallelScatterGatherQueryHelper parallelScatterGatherQueryHelper, EventSchedulerRegistry eventSchedulerRegistry, EventProxyConnector eventProxyConnector, @Named(value="eventProxyForMigration.enabled") String eventProxyEnabled, StateTraversalPath stateTraversalPath, StateTraversalPathDAO stateTraversalPathDAO) {
        this.eventsDAO = eventsDAO;
        this.stateMachinesDAO = stateMachinesDAO;
        this.smEntityManager = smEntityManager;
        this.smExecutionEntitiesManager = smExecutionEntitiesManager;
        this.statesDAO = statesDAO;
        this.auditDAO = auditDAO;
        this.auditEntityManager = auditEntityManager;
        this.eventSchedulerRegistry = eventSchedulerRegistry;
        this.workFlowExecutionController = workFlowExecutionController;
        this.objectMapper = new ObjectMapper();
        this.metricsClient = metricsClient;
        this.parallelScatterGatherQueryHelper = parallelScatterGatherQueryHelper;
        this.eventProxyConnector = eventProxyConnector;
        this.eventProxyEnabled = eventProxyEnabled;
        this.stateTraversalPathDAO = stateTraversalPathDAO;
    }

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response createStateMachine(StateMachineDefinition stateMachineDefinition) throws Exception {
        if (stateMachineDefinition == null) {
            throw new IllegalRepresentationException("State machine definition is empty");
        }
        StateMachine stateMachine = null;
        String stateMachineInstanceId = stateMachineDefinition.getCorrelationId() != null && !stateMachineDefinition.getCorrelationId().isEmpty() ? stateMachineDefinition.getCorrelationId() : UUID.randomUUID().toString();
        if (stateMachineDefinition.getClientElbId() == null) {
            stateMachineDefinition.setClientElbId("defaultElbId");
        }
        try {
            stateMachine = this.createAndInitStateMachine(stateMachineInstanceId, stateMachineDefinition);
            this.metricsClient.markMeter("stateMachine." + stateMachine.getName() + ".started");
        }
        catch (ConstraintViolationException ex) {
            if (ex.getCause() != null && ex.getCause().getMessage().toLowerCase().contains("duplicate entry")) {
                return Response.status((int)Response.Status.CONFLICT.getStatusCode()).entity((Object)ex.getCause().getMessage()).build();
            }
            logger.error("Constraint Violation during creating or initiating StateMachine with id {} {} {}", (Object)stateMachineInstanceId, (Object)ex.getCause().getMessage(), (Object)ex.getStackTrace());
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity(ex.getCause() != null ? ex.getCause().getMessage() : null).build();
        }
        catch (CreateStateMachineException ex) {
            logger.error("Failed During Creating StateMachine with id {} {}", (Object)stateMachineInstanceId, (Object)ex.getStackTrace());
            return Response.status((int)Response.Status.PRECONDITION_FAILED.getStatusCode()).entity((Object)(ex.getMessage() != null ? ex.getMessage() : null)).build();
        }
        catch (Exception ex) {
            logger.error("Failed During Creating StateMachine and StateTraversal or Initiating StateMachine with id {} {}", (Object)stateMachineInstanceId, (Object)ex.getMessage(), (Object)ex);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity(ex.getCause() != null ? ex.getCause().getMessage() : null).build();
        }
        return Response.status((int)Response.Status.CREATED.getStatusCode()).entity((Object)stateMachine.getId()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateMachine createAndInitStateMachine(String stateMachineInstanceId, StateMachineDefinition stateMachineDefinition) throws Exception {
        try {
            StateMachine stateMachine = this.smExecutionEntitiesManager.createStateMachine(new FSMId(stateMachineInstanceId), stateMachineDefinition);
            LoggingUtils.registerStateMachineIdForLogging((String)stateMachine.getId());
            logger.info("Created state machine with Id: {}", (Object)stateMachine.getId());
            this.workFlowExecutionController.initAndStart(stateMachine, stateMachine.getContext());
            StateMachine stateMachine2 = stateMachine;
            return stateMachine2;
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    private Boolean isEventSourceContainsReplayable(String eventSource) {
        if (eventSource != null && eventSource.toLowerCase().contains("flux_runtime_replay_internal".toLowerCase())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Path(value="/{machineId}/context/events")
    @Timed
    public Response submitEvent(@PathParam(value="machineId") String machineId, @QueryParam(value="searchField") String searchField, @QueryParam(value="triggerTime") Long triggerTime, EventData eventData) throws Exception {
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)machineId);
            logger.info("Received event: {} for state machine: {}", (Object)eventData.getName(), (Object)machineId);
            StateMachine stateMachine = null;
            stateMachine = this.stateMachinesDAO.findById(machineId);
            if (this.isEventSourceContainsReplayable(eventData.getEventSource()).booleanValue()) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.").build();
                return response;
            }
            if (eventData.getData() == null || eventData.getName() == null) {
                Response response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"Event Data|Name cannot be null.").build();
                return response;
            }
            if (eventData.getCancelled() != null && eventData.getCancelled().booleanValue()) {
                Response response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"Event cancellation not allowed here. Please modify isCancelled param to false and retry.").build();
                return response;
            }
            if (this.eventsDAO.findValidReplayEventBySMIdAndName(machineId, eventData.getName()).isPresent()) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"Input event is a Replay Event. Replay Event update not allowed via this api.").build();
                return response;
            }
            if (stateMachine == null) {
                if (this.eventProxyEnabled.equalsIgnoreCase("yes")) {
                    logger.warn("StateMachine " + machineId + " not found in this cluster. Forwarding this event to the old cluster.");
                    if (triggerTime == null) {
                        try {
                            this.eventProxyConnector.submitEvent(eventData.getName(), (Object)eventData.getData(), machineId, eventData.getEventSource());
                        }
                        catch (Exception ex) {
                            logger.error("Unable to forward event to old endpoint, error {}", (Throwable)ex);
                        }
                    } else {
                        try {
                            this.eventProxyConnector.submitScheduledEvent(eventData.getName(), (Object)eventData.getData(), machineId, eventData.getEventSource(), triggerTime);
                        }
                        catch (Exception ex) {
                            logger.error("Unable to forward scheduled event to old endpoint, error {}", (Throwable)ex);
                        }
                    }
                    Response ex = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)("State Machine with Id: " + machineId + " not found on this cluster. Forwarding the event to the old cluster")).build();
                    return ex;
                }
                logger.error("StateMachine not found with id: {}, rejecting the event", (Object)machineId);
                Response ex = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("StateMachine not found with id: " + machineId + ", rejecting the event")).build();
                return ex;
            }
            if (stateMachine.getStatus() == StateMachineStatus.cancelled) {
                logger.info("Discarding event: {} as State machine: {} is in cancelled state", (Object)eventData.getName(), (Object)stateMachine.getId());
                Response ex = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)("State machine with Id: " + stateMachine.getId() + " is in 'cancelled' state. Discarding the event.")).build();
                return ex;
            }
            if (triggerTime == null) {
                logger.info("Received event: {} for state machine: {}", (Object)eventData.getName(), (Object)machineId);
                try {
                    Event event = this.eventsDAO.findValidEventBySMIdAndName(machineId, eventData.getName());
                    VersionedEventData versionedEventData = new VersionedEventData(eventData.getName(), eventData.getType(), eventData.getData(), eventData.getEventSource(), eventData.getCancelled(), event.getExecutionVersion());
                    if (versionedEventData.getCancelled() != null && versionedEventData.getCancelled().booleanValue()) {
                        this.workFlowExecutionController.handlePathCancellation(stateMachine.getId(), versionedEventData);
                    } else {
                        this.workFlowExecutionController.postEvent(versionedEventData, stateMachine.getId());
                    }
                    Response response = Response.status((Response.Status)Response.Status.ACCEPTED).build();
                    return response;
                }
                catch (IllegalEventException ex) {
                    Response response = Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)ex.getMessage()).build();
                    LoggingUtils.deRegisterStateMachineIdForLogging();
                    return response;
                }
            }
            logger.info("Received event: {} for state machine: {} with triggerTime: {}", (Object)eventData.getName(), (Object)machineId, (Object)triggerTime);
            if (searchField == null || !searchField.equals(CORRELATION_ID)) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"searchField=correlationId is missing in the request").build();
                return response;
            }
            if (triggerTime > 9999999999L) {
                triggerTime = triggerTime / 1000L;
            }
            this.eventSchedulerRegistry.registerEvent(machineId, eventData.getName(), this.objectMapper.writeValueAsString((Object)eventData), triggerTime);
            Response response = Response.status((Response.Status)Response.Status.ACCEPTED).build();
            return response;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{machineId}/context/replayevent")
    @Timed
    public Response submitReplayEvent(@PathParam(value="machineId") String machineId, @QueryParam(value="searchField") String searchField, EventData eventData) throws Exception {
        try {
            if (machineId == null || eventData == null || machineId.isEmpty()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please send valid values for machineId and EventData ").build();
                return response;
            }
            if (this.checkIfEventDataIsEmpty(eventData).booleanValue()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event Data cannot be empty").build();
                return response;
            }
            if (this.isEventSourceContainsReplayable(eventData.getEventSource()).booleanValue()) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.").build();
                return response;
            }
            if (eventData.getCancelled() != null && eventData.getCancelled().booleanValue()) {
                Response response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"Event cancellation not allowed here. Please modify isCancelled param to false and retry.").build();
                return response;
            }
            LoggingUtils.registerStateMachineIdForLogging((String)machineId);
            if (eventData.getEventSource() != null) {
                String eventSource = eventData.getEventSource() + ":" + "flux_runtime_replay_internal";
                eventData.setEventSource(eventSource);
            } else {
                eventData.setEventSource("flux_runtime_replay_internal");
            }
            logger.info("Received replay event: {} for state machine id: {}", (Object)eventData.getName(), (Object)machineId);
            StateMachine stateMachine = null;
            stateMachine = this.stateMachinesDAO.findById(machineId);
            if (stateMachine == null) {
                if (this.eventProxyEnabled.equalsIgnoreCase("yes")) {
                    logger.warn("StateMachine with id: {} not found in this cluster. Forwarding this event to the old cluster. ", (Object)machineId);
                    try {
                        this.eventProxyConnector.submitReplayEvent(eventData.getName(), (Object)eventData.getData(), machineId, eventData.getEventSource());
                    }
                    catch (Exception ex) {
                        logger.error("Unable to forward event to old endpoint, error {}", (Throwable)ex);
                        Response response = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)ex.getMessage()).build();
                        LoggingUtils.deRegisterStateMachineIdForLogging();
                        return response;
                    }
                    Response ex = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)("State Machine with Id: " + machineId + " not found on this cluster. Forwarding the event to the old cluster")).build();
                    return ex;
                }
                logger.error("StateMachine not found with id: {}, rejecting the event", (Object)machineId);
                Response ex = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("StateMachine not found with id: " + machineId + ", rejecting the event")).build();
                return ex;
            }
            if (stateMachine.getStatus() == StateMachineStatus.cancelled) {
                logger.info("Discarding replay event: {} as State machine: {} is in cancelled state", (Object)eventData.getName(), (Object)stateMachine.getId());
                Response ex = Response.status((int)Response.Status.PRECONDITION_FAILED.getStatusCode()).entity((Object)("State machine with Id: " + stateMachine.getId() + " is in 'cancelled' state. Discarding the replay event.")).build();
                return ex;
            }
            Optional replayEvent = this.eventsDAO.findValidReplayEventBySMIdAndName(machineId, eventData.getName());
            if (replayEvent.isPresent()) {
                logger.info("Found replay event: {} with execution version: {} for SMId: {} ", (Object)eventData.getName(), (Object)((Event)replayEvent.get()).getExecutionVersion(), (Object)machineId);
                eventData.setType(((Event)replayEvent.get()).getType());
                this.workFlowExecutionController.postReplayEvent(eventData, stateMachine);
                Response response = Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("Successfully submitted ReplayEvent: " + eventData.getName() + ". Check Flux-Dashboard for this StateMachine Id: " + machineId)).build();
                return response;
            }
            logger.error("Triggered input event {} doesn't exist as a replay event in database. Replay Event is identified by eventSource suffix {}", (Object)eventData.getName(), (Object)"flux_runtime_replay_internal");
            Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Triggered input event " + eventData.getName() + " doesn't exist as a replay event in database. Replay Event is identified by eventSource suffix " + "flux_runtime_replay_internal")).build();
            return response;
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{machineId}/context/eventandstatus")
    @Timed
    public Response submitEvent(@PathParam(value="machineId") String machineId, EventAndExecutionData eventAndExecutionData) throws Exception {
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)machineId);
            StateMachine stateMachine = null;
            stateMachine = this.stateMachinesDAO.findById(machineId);
            if (stateMachine == null) {
                Response response = Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)("State machine with Id: " + machineId + " not found")).build();
                return response;
            }
            VersionedEventData versionedEventData = eventAndExecutionData.getVersionedEventData();
            if (this.isEventSourceContainsReplayable(versionedEventData.getEventSource()).booleanValue()) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"EventSource cannot contain flux_runtime_replay_internal as it is specific to replay event").build();
                return response;
            }
            ExecutionUpdateData executionUpdateData = eventAndExecutionData.getExecutionUpdateData();
            try {
                if (executionUpdateData.getTaskExecutionVersion().equals(this.statesDAO.findById(machineId, executionUpdateData.getTaskId()).getExecutionVersion())) {
                    logger.info("Received event:{} with eventExecutionVersion:{} from state: {} with stateExecutionVersion:{} for state machine: {}", (Object)versionedEventData.getName(), (Object)versionedEventData.getExecutionVersion(), (Object)executionUpdateData.getTaskId(), (Object)executionUpdateData.getTaskExecutionVersion(), (Object)machineId);
                    if (versionedEventData.getCancelled() != null && versionedEventData.getCancelled().booleanValue()) {
                        this.workFlowExecutionController.updateTaskStatusAndHandlePathCancellation(machineId, eventAndExecutionData);
                    } else {
                        this.workFlowExecutionController.updateTaskStatus(machineId, executionUpdateData.getTaskId(), executionUpdateData.getTaskExecutionVersion(), executionUpdateData);
                        this.workFlowExecutionController.postEvent(versionedEventData, stateMachine.getId());
                    }
                } else {
                    logger.info("Discarding event:{} with eventExecutionVersion:{} from state: {} with stateExecutionVersion:{} for state machine: {}. StateExecutionVersion is not valid anymore. EventData will be saved in data store for audit purpose with eventExecutionVersion:{}.", (Object)versionedEventData.getName(), (Object)versionedEventData.getExecutionVersion(), (Object)executionUpdateData.getTaskId(), (Object)executionUpdateData.getTaskExecutionVersion(), (Object)machineId, (Object)versionedEventData.getExecutionVersion());
                    this.workFlowExecutionController.persistDiscardedEvent(machineId, versionedEventData);
                    this.auditDAO.create(machineId, new AuditRecord(machineId, executionUpdateData.getTaskId(), Long.valueOf(executionUpdateData.getCurrentRetryCount()), Status.invalid, null, "Discarded : StateExecutionVersion is no more valid.", executionUpdateData.getTaskExecutionVersion(), executionUpdateData.getDependentAuditEvents()));
                }
            }
            catch (IllegalEventException ex) {
                Response response = Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)ex.getMessage()).build();
                LoggingUtils.deRegisterStateMachineIdForLogging();
                return response;
            }
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{machineId}/context/eventupdate")
    @Timed
    public Response updateEvent(@PathParam(value="machineId") String machineId, EventData eventData) throws Exception {
        if (machineId.isEmpty() || machineId == null) {
            logger.error("machineId {} null or empty.", (Object)machineId);
            return Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"StateMachineId cannot be null or empty.").build();
        }
        if (this.isEventSourceContainsReplayable(eventData.getEventSource()).booleanValue()) {
            return Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.").build();
        }
        StateMachine stateMachine = this.stateMachinesDAO.findById(machineId);
        if (stateMachine == null) {
            logger.error("State Machine with input machineId {} doesn't exist.", (Object)machineId);
            return Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)"State Machine with input machineId doesn't exist.").build();
        }
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)machineId);
            if (eventData.getData() == null || eventData.getName() == null || eventData.getEventSource() == null) {
                Response response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"Event Data|Name|Source cannot be null.").build();
                return response;
            }
            if (eventData.getCancelled() != null && eventData.getCancelled().booleanValue()) {
                Response response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"Event cancellation not allowed here. Please modify isCancelled param to false and retry.").build();
                return response;
            }
            if (this.eventsDAO.findValidReplayEventBySMIdAndName(machineId, eventData.getName()).isPresent()) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"Input event is a Replay Event. Replay Event update not allowed via this api.").build();
                return response;
            }
            Event event = this.eventsDAO.findValidEventBySMIdAndName(machineId, eventData.getName());
            if (event == null) {
                logger.error("Event with input event Name {} doesn't exist or is invalid.", (Object)eventData.getName());
                Response response = Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)"Event with input event Name doesn't exist or is invalid.").build();
                return response;
            }
            if (event.getStatus() != Event.EventStatus.triggered) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"Input event is not in triggered state.").build();
                return response;
            }
            logger.info("Received event update request for event:{}", (Object)eventData.getName());
            List states = this.statesDAO.findStatesByDependentEvent(machineId, eventData.getName());
            if (this.validateEventUpdate(states)) {
                VersionedEventData versionedEventData = new VersionedEventData(eventData.getName(), eventData.getType(), eventData.getData(), eventData.getEventSource(), eventData.getCancelled(), event.getExecutionVersion());
                this.workFlowExecutionController.updateEventData(machineId, versionedEventData);
                for (State state : states) {
                    Status stateStatus = state.getStatus();
                    if (stateStatus != Status.initialized && stateStatus != Status.errored && stateStatus != Status.sidelined) continue;
                    try {
                        this.workFlowExecutionController.unsidelineState(state.getStateMachineId(), state.getId());
                    }
                    catch (Exception ex) {
                        logger.warn("Unable to unsideline for stateId:{}, execution version:{} msg:{}", (Object)state.getId(), (Object)state.getExecutionVersion(), (Object)ex.getMessage());
                    }
                }
                Response response = Response.status((Response.Status)Response.Status.ACCEPTED).build();
                return response;
            }
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
        return Response.status((int)Response.Status.CONFLICT.getStatusCode()).entity((Object)"Current stateMachine's state is not eligible for this event's update, try after some time.").build();
    }

    public boolean validateEventUpdate(List<State> states) {
        boolean canUpdateEventData = false;
        for (State state : states) {
            Status status = state.getStatus();
            if (status == Status.running) {
                canUpdateEventData = false;
                break;
            }
            if (status != Status.initialized && status != Status.errored && status != Status.sidelined) continue;
            canUpdateEventData = true;
        }
        return canUpdateEventData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{machineId}/context/internaleventupdate")
    @Timed
    public Response updateInternalEvent(@PathParam(value="machineId") String machineId, EventData eventData) throws Exception {
        if (machineId.isEmpty() || machineId == null) {
            logger.error("machineId {} null or empty.", (Object)machineId);
            return Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"StateMachineId cannot be null or empty.").build();
        }
        if (this.isEventSourceContainsReplayable(eventData.getEventSource()).booleanValue()) {
            return Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"EventSource cannot contain flux_runtime_replay_internal as it is for internal use only. Modify Event Source and retry.").build();
        }
        LoggingUtils.registerStateMachineIdForLogging((String)machineId);
        StateMachine stateMachine = this.stateMachinesDAO.findById(machineId);
        if (stateMachine == null) {
            logger.error("State Machine with input machineId {} doesn't exist.", (Object)machineId);
            return Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)("State Machine with input machineId: " + machineId + " doesn't exist.")).build();
        }
        try {
            if (eventData.getData() == null || eventData.getName() == null) {
                Response response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"Event Data|Name cannot be null.").build();
                return response;
            }
            if (eventData.getCancelled() != null && eventData.getCancelled().booleanValue()) {
                Response response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"Event cancellation not allowed here. Please modify isCancelled param to false and retry.").build();
                return response;
            }
            if (this.eventsDAO.findValidReplayEventBySMIdAndName(machineId, eventData.getName()).isPresent()) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"Input event is a Replay Event. Replay Event update is not allowed.").build();
                return response;
            }
            Event event = this.eventsDAO.findValidEventBySMIdAndName(machineId, eventData.getName());
            if (event == null) {
                logger.error("Event with input event Name {} doesn't exist.", (Object)eventData.getName());
                Response response = Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)"Event with input event Name doesn't exist.").build();
                return response;
            }
            if (event.getStatus() != Event.EventStatus.triggered) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"Input event is not in triggered state.").build();
                return response;
            }
            logger.info("Received event update request for event: {}", (Object)eventData.getName());
            ArrayList<State> replayableStates = new ArrayList<State>();
            List states = this.statesDAO.findStatesByDependentEvent(machineId, eventData.getName());
            for (State state : states) {
                if (!this.statesDAO.findById(machineId, state.getId()).getReplayable().booleanValue()) continue;
                replayableStates.add(state);
            }
            if (replayableStates.isEmpty()) {
                Response response = Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)("None of the states having dependency of event " + eventData.getName() + " is replayable. Prerequisite : At least one of the dependent states of input event must be replayable.")).build();
                return response;
            }
            if (this.validateInternalEventUpdate(replayableStates)) {
                VersionedEventData versionedEventData = new VersionedEventData(event.getName(), event.getType(), eventData.getData(), event.getEventSource(), Boolean.FALSE, event.getExecutionVersion());
                this.workFlowExecutionController.updateEventData(machineId, versionedEventData);
                Response response = Response.status((Response.Status)Response.Status.ACCEPTED).build();
                return response;
            }
        }
        catch (Exception e) {
            Response response = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)(e.getMessage() + e.getStackTrace())).build();
            return response;
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
        return Response.status((int)Response.Status.CONFLICT.getStatusCode()).entity((Object)"Current stateMachine's state is not eligible for this event's update. None of the dependent replayable states is completed.").build();
    }

    public boolean validateInternalEventUpdate(List<State> states) {
        boolean canUpdateInternalEventData = false;
        for (State state : states) {
            Status status = state.getStatus();
            if (status != Status.completed) continue;
            canUpdateInternalEventData = true;
            break;
        }
        return canUpdateInternalEventData;
    }

    @POST
    @Path(value="/{machineId}/{stateId}/{taskExecutionVersion}/status")
    @Timed
    public Response updateStatus(@PathParam(value="machineId") String machineId, @PathParam(value="stateId") Long stateId, @PathParam(value="taskExecutionVersion") Long taskExecutionVersion, ExecutionUpdateData executionUpdateData) throws Exception {
        this.workFlowExecutionController.updateTaskStatus(machineId, stateId, taskExecutionVersion, executionUpdateData);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/{machineId}/{stateId}/{taskExecutionVersion}/retries/inc")
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Response incrementRetry(@PathParam(value="machineId") String machineId, @PathParam(value="stateId") Long stateId, @PathParam(value="taskExecutionVersion") Long taskExecutionVersion) {
        this.workFlowExecutionController.incrementExecutionRetries(machineId, stateId, taskExecutionVersion);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/redrivetask/{machineId}/taskId/{taskId}/taskExecutionVersion/{taskExecutionVersion}")
    @Timed
    public Response redriveTask(@PathParam(value="machineId") String machineId, @PathParam(value="taskId") Long taskId, @PathParam(value="taskExecutionVersion") Long executionVersion) throws Exception {
        this.workFlowExecutionController.redriveTask(machineId, taskId, executionVersion);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/{machineId}/fsmdata")
    @Produces(value={"application/json"})
    public Response getFsmGraphData(@PathParam(value="machineId") String machineId) throws IOException {
        return Response.status((int)200).entity((Object)this.getGraphData(machineId)).build();
    }

    @GET
    @Path(value="/{stateMachineName}/states/errored")
    @Produces(value={"application/json"})
    public Response getErroredStates(@PathParam(value="stateMachineName") String stateMachineName, @QueryParam(value="fromTime") String fromTime, @QueryParam(value="toTime") String toTime) {
        Timestamp toTimestamp;
        if (fromTime == null || toTime == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Required params fromTime/toTime are not provided").build();
        }
        Timestamp fromTimestamp = Timestamp.valueOf(fromTime);
        if (fromTimestamp.after(toTimestamp = Timestamp.valueOf(toTime))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("fromTime: " + fromTime + " should be before toTime: " + toTime)).build();
        }
        return Response.status((int)200).entity((Object)this.parallelScatterGatherQueryHelper.findErroredStates(stateMachineName, fromTimestamp, toTimestamp)).build();
    }

    @GET
    @Path(value="/{stateMachineName}/states/listbytime")
    @Produces(value={"application/json"})
    public Response getStatesByTime(@PathParam(value="stateMachineName") String stateMachineName, @QueryParam(value="fromTime") String fromTime, @QueryParam(value="toTime") String toTime, @QueryParam(value="stateName") String stateName, @QueryParam(value="statuses") List<String> statusStrings) throws Exception {
        Timestamp toTimestamp;
        if (fromTime == null || toTime == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Required params fromTime/toTime are not provided").build();
        }
        Timestamp fromTimestamp = Timestamp.valueOf(fromTime);
        if (fromTimestamp.after(toTimestamp = Timestamp.valueOf(toTime))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("fromTime: " + fromTime + " should be before toTime: " + toTime)).build();
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        if (statusStrings != null && !statusStrings.isEmpty()) {
            for (String status : statusStrings) {
                try {
                    statuses.add(Status.valueOf((String)status));
                }
                catch (IllegalArgumentException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("status: " + status + " must be one of initialized, running, completed, cancelled, errored, sidelined, unsidelined")).build();
                }
            }
        }
        return Response.status((int)200).entity((Object)this.parallelScatterGatherQueryHelper.findStatesByStatus(stateMachineName, fromTimestamp, toTimestamp, stateName, statuses)).build();
    }

    @PUT
    @Path(value="/{stateMachineId}/{stateId}/unsideline")
    @Produces(value={"application/json"})
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Response unsidelineState(@PathParam(value="stateMachineId") String stateMachineId, @PathParam(value="stateId") Long stateId) {
        this.workFlowExecutionController.unsidelineState(stateMachineId, stateId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{stateMachineId}/{stateId}/resetreplayretries")
    @Produces(value={"application/json"})
    public Response resetAttemptedNoOfRetries(@PathParam(value="stateMachineId") String stateMachineId, @PathParam(value="stateId") Long stateId) {
        if (stateMachineId == null || stateMachineId.isEmpty() || stateId == null) {
            logger.error("machineId {} null or empty.", (Object)stateMachineId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"StateMachineId cannot be null or empty").build();
        }
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)stateMachineId);
            Optional traversalPathStates = this.stateTraversalPathDAO.findById(stateMachineId, stateId);
            if (traversalPathStates.isPresent()) {
                List stateIds = ((StateTraversalPath)traversalPathStates.get()).getNextDependentStates();
                HashSet<String> eventNames = new HashSet<String>();
                for (State s : this.statesDAO.findAllStatesForGivenStateIds(stateMachineId, stateIds)) {
                    try {
                        if (s.getReplayable().booleanValue()) {
                            List dependencies = s.getDependencies();
                            dependencies.forEach(e -> {
                                Optional event = this.eventsDAO.findValidReplayEventBySMIdAndName(stateMachineId, e);
                                event.ifPresent(replayEvent -> eventNames.add(replayEvent.getName()));
                            });
                        }
                        eventNames.add(this.getOutputEventName(s.getOutputEvent()));
                    }
                    catch (IOException e2) {
                        logger.error("Exception in de-serializing the Json output: {} ", (Object)e2.getMessage());
                        Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e2.getMessage()).build();
                        LoggingUtils.deRegisterStateMachineIdForLogging();
                        return response;
                    }
                }
                this.workFlowExecutionController.deleteInvalidEvents(stateMachineId, new ArrayList<String>(eventNames));
                this.workFlowExecutionController.resetAttemptedNumberOfRetries(stateMachineId, stateId);
                Response response = Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("Retries reset to zero for stateId: " + stateId)).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("Not a replayable state: " + stateId)).build();
            return response;
        }
        catch (Exception e3) {
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e3.getMessage()).build();
            return response;
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    @PUT
    @Path(value="/{stateMachineId}/cancel")
    @Produces(value={"application/json"})
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Response cancelWorkflow(@PathParam(value="stateMachineId") String stateMachineId, @QueryParam(value="searchField") String searchField) {
        StateMachine stateMachine = null;
        stateMachine = this.stateMachinesDAO.findById(stateMachineId);
        if (stateMachine == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("State machine with id: " + stateMachineId + " not found")).build();
        }
        this.workFlowExecutionController.cancelWorkflow(stateMachine);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/{stateMachineId}/info")
    @Produces(value={"application/json"})
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Response getStateMachine(@PathParam(value="stateMachineId") String stateMachineId, @QueryParam(value="searchField") String searchField) {
        StateMachine stateMachine = null;
        stateMachine = this.stateMachinesDAO.findById(stateMachineId);
        if (stateMachine == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("State machine with id: " + stateMachineId + " not found")).build();
        }
        List events = this.eventsDAO.findBySMInstanceId(stateMachine.getId());
        List auditRecords = this.auditDAO.findBySMInstanceId(stateMachine.getId());
        Map stateMachineInfo = (Map)this.objectMapper.convertValue((Object)stateMachine, Map.class);
        stateMachineInfo.put("events", events);
        stateMachineInfo.put("auditrecords", auditRecords);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)stateMachineInfo).build();
    }

    private FsmGraph getGraphData(String machineId) throws IOException {
        String fsmId = machineId;
        StateMachine stateMachine = (StateMachine)this.smEntityManager.findEntity((Object)new FSMId(fsmId));
        if (stateMachine == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("State machine with Id: " + machineId + " not found")).build());
        }
        FsmGraph fsmGraph = new FsmGraph();
        LinkedList<Long> erroredStateIds = new LinkedList<Long>();
        for (State state2 : stateMachine.getStates()) {
            if (state2.getStatus() != Status.errored && state2.getStatus() != Status.sidelined) continue;
            erroredStateIds.add(state2.getId());
        }
        Collections.sort(erroredStateIds);
        fsmGraph.setErroredStateIds(erroredStateIds);
        fsmGraph.setStateMachineId(stateMachine.getId());
        fsmGraph.setFsmVersion(stateMachine.getVersion());
        fsmGraph.setFsmName(stateMachine.getName());
        fsmGraph.setFsmStatus(stateMachine.getStatus());
        Map<String, Event> stateMachineEvents = this.eventsDAO.findBySMInstanceId(stateMachine.getId()).stream().collect(Collectors.toMap(Event::getName, event -> event));
        HashSet<String> allOutputEventNames = new HashSet<String>();
        RAMContext ramContext = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        for (State state3 : stateMachine.getStates()) {
            FsmGraphVertex vertex = new FsmGraphVertex(state3.getId(), this.getStateDisplayName(state3.getName()), state3.getStatus().name(), state3.getExecutionVersion());
            if (state3.getOutputEvent() != null) {
                EventDefinition eventDefinition = (EventDefinition)this.objectMapper.readValue(state3.getOutputEvent(), EventDefinition.class);
                Event outputEvent = stateMachineEvents.get(eventDefinition.getName());
                fsmGraph.addVertex(vertex, new FsmGraphEdge(this.getEventDisplayName(outputEvent.getName()), outputEvent.getStatus().name(), outputEvent.getEventSource(), outputEvent.getEventData() + "#" + outputEvent.getExecutionVersion(), outputEvent.getUpdatedAt()));
                Set dependantStates = ramContext.getDependantStates(outputEvent.getName());
                dependantStates.forEach(aState -> fsmGraph.addOutgoingEdge(vertex, aState.getId()));
                allOutputEventNames.add(outputEvent.getName());
                continue;
            }
            fsmGraph.addVertex(vertex, new FsmGraphEdge(null, null, null, null, null));
        }
        Set initialStates = ramContext.getInitialStates(Collections.emptySet());
        if (!initialStates.isEmpty()) {
            FsmGraphEdge initEdge = new FsmGraphEdge(TRIGGER, Event.EventStatus.triggered.name(), TRIGGER, null, null);
            initialStates.forEach(state -> initEdge.addOutgoingVertex(state.getId()));
            fsmGraph.addInitStateEdge(initEdge);
        }
        HashSet<String> eventsGivenOnWorkflowTrigger = new HashSet<String>(stateMachineEvents.keySet());
        eventsGivenOnWorkflowTrigger.removeAll(allOutputEventNames);
        eventsGivenOnWorkflowTrigger.forEach(workflowTriggeredEventName -> {
            Event correspondingEvent = (Event)stateMachineEvents.get(workflowTriggeredEventName);
            FsmGraphEdge initEdge = new FsmGraphEdge(this.getEventDisplayName((String)workflowTriggeredEventName), correspondingEvent.getStatus().name(), correspondingEvent.getEventSource(), correspondingEvent.getEventData() + "#" + correspondingEvent.getExecutionVersion(), correspondingEvent.getUpdatedAt());
            Set dependantStates = ramContext.getDependantStates(workflowTriggeredEventName);
            dependantStates.forEach(state -> initEdge.addOutgoingVertex(state.getId()));
            fsmGraph.addInitStateEdge(initEdge);
        });
        fsmGraph.setAuditData(Arrays.asList(this.auditEntityManager.findEntitities((Object)new FSMId(stateMachine.getId()))));
        return fsmGraph;
    }

    private String getEventDisplayName(String eventName) {
        return eventName == null ? null : this.getDisplayName(eventName.substring(eventName.lastIndexOf(".") + 1));
    }

    private String getStateDisplayName(String stateName) {
        return this.getDisplayName(stateName);
    }

    private String getDisplayName(String label) {
        if (label == null) {
            return null;
        }
        String words = label.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), TRIGGER);
        StringBuffer sb = new StringBuffer();
        for (String s : words.split(TRIGGER)) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sb.append(s.substring(1).toLowerCase());
            sb.append(TRIGGER);
        }
        return sb.toString().trim();
    }

    private Boolean checkIfEventDataIsEmpty(EventData eventData) {
        if (eventData.getName() == null || eventData.getType() == null || eventData.getData() == null || eventData.getName().isEmpty() || eventData.getType().isEmpty() || eventData.getData().isEmpty()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getOutputEventName(String outputEvent) throws IOException {
        return outputEvent != null ? ((EventDefinition)this.objectMapper.readValue(outputEvent, EventDefinition.class)).getName() : null;
    }

    @GET
    @Path(value="/{machineId}/{eventName}/{taskExecutionVersion}/eventdata")
    @Produces(value={"application/json"})
    public Response getEventData(@PathParam(value="machineId") String smId, @PathParam(value="eventName") String eventName, @PathParam(value="taskExecutionVersion") Long taskExecutionVersion) {
        if (smId == null || eventName == null || taskExecutionVersion == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"smId/eventName/taskExecutionVersion cannot be null").build();
        }
        try {
            Event event = this.workFlowExecutionController.getEventData(smId, eventName, taskExecutionVersion);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new Gson().toJson((Object)event)).build();
        }
        catch (IllegalEventException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

