/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.clientelb.dao.ClientElbDAOImpl;
import com.flipkart.flux.clientelb.dao.iface.ClientElbDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.ClientElb;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.guice.interceptor.TransactionInterceptor;
import com.flipkart.flux.persistence.AuditEntityManager;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.StateMachineEntityManager;
import com.flipkart.flux.persistence.StateMachineExecutionEntitiesManager;
import com.flipkart.flux.persistence.dao.iface.AuditDAO;
import com.flipkart.flux.persistence.dao.iface.AuditDAOV1;
import com.flipkart.flux.persistence.dao.iface.EventsDAO;
import com.flipkart.flux.persistence.dao.iface.EventsDAOV1;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAOV1;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAOV1;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.persistence.dao.impl.AuditDAOImpl;
import com.flipkart.flux.persistence.dao.impl.AuditDAOV1Impl;
import com.flipkart.flux.persistence.dao.impl.EventsDAOImpl;
import com.flipkart.flux.persistence.dao.impl.EventsDAOV1Impl;
import com.flipkart.flux.persistence.dao.impl.StateMachinesDAOImpl;
import com.flipkart.flux.persistence.dao.impl.StateMachinesDAOV1Impl;
import com.flipkart.flux.persistence.dao.impl.StateTraversalPathDAOImpl;
import com.flipkart.flux.persistence.dao.impl.StateTraversalPathDAOV1Impl;
import com.flipkart.flux.persistence.dao.impl.StatesDAOImpl;
import com.flipkart.flux.persistence.impl.SessionFactoryContextImpl;
import com.flipkart.flux.redriver.dao.MessageDao;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.flux.shard.ShardId;
import com.flipkart.flux.shard.ShardPairModel;
import com.flipkart.flux.type.BlobType;
import com.flipkart.flux.type.ListJsonType;
import com.flipkart.flux.type.StoreFQNType;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.Transactional;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.configuration.Configuration;
import org.hibernate.SessionFactory;
import org.hibernate.usertype.UserType;

public class ShardModule
extends AbstractModule {
    public static final String FLUX_HIBERNATE_SHARD_CONFIG_NAME_SPACE = "shard.Pair.Model.List";
    public static final String FLUX_HIBERNATE_CONFIG_NAME_SPACE = "flux.Hibernate";
    public static final String FLUX_READ_ONLY_HIBERNATE_CONFIG_NAME_SPACE = "fluxReadOnly.Hibernate";

    protected void configure() {
        this.bind(AuditDAO.class).to(AuditDAOImpl.class).in(Singleton.class);
        this.bind(AuditDAOV1.class).to(AuditDAOV1Impl.class).in(Singleton.class);
        this.bind(EventsDAO.class).to(EventsDAOImpl.class).in(Singleton.class);
        this.bind(EventsDAOV1.class).to(EventsDAOV1Impl.class).in(Singleton.class);
        this.bind(StateMachinesDAO.class).to(StateMachinesDAOImpl.class).in(Singleton.class);
        this.bind(StateMachinesDAOV1.class).to(StateMachinesDAOV1Impl.class).in(Singleton.class);
        this.bind(StatesDAO.class).to(StatesDAOImpl.class).in(Singleton.class);
        this.bind(ClientElbDAO.class).to(ClientElbDAOImpl.class).in(Singleton.class);
        this.bind(StateTraversalPathDAO.class).to(StateTraversalPathDAOImpl.class).in(Singleton.class);
        this.bind(StateTraversalPathDAOV1.class).to(StateTraversalPathDAOV1Impl.class).in(Singleton.class);
        Provider provider = this.getProvider(Key.get(SessionFactoryContext.class, (Annotation)Names.named((String)"fluxSessionFactoriesContext")));
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor((javax.inject.Provider)provider);
        this.bindInterceptor(Matchers.not((Matcher)Matchers.inPackage((Package)MessageDao.class.getPackage())), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionInterceptor});
        this.bindInterceptor(Matchers.not((Matcher)Matchers.inPackage((Package)ScheduledMessage.class.getPackage())), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionInterceptor});
        this.requestStaticInjection(new Class[]{StateMachineEntityManager.class});
        this.requestStaticInjection(new Class[]{AuditEntityManager.class});
        this.requestStaticInjection(new Class[]{StateMachineExecutionEntitiesManager.class});
    }

    @Provides
    @Singleton
    @Named(value="fluxMasterSlavePairList")
    public List<ShardPairModel> getFluxMasterSlavePairList(YamlConfiguration yamlConfiguration) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            TypeReference<List<ShardPairModel>> typeRef = new TypeReference<List<ShardPairModel>>(){};
            List masterSlavePairList = (List)objectMapper.convertValue((Object)yamlConfiguration.getList(FLUX_HIBERNATE_SHARD_CONFIG_NAME_SPACE), (TypeReference)typeRef);
            return masterSlavePairList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FluxError(FluxError.ErrorType.runtime, "Not able to read Master Slave Config from Config File", e.getCause());
        }
    }

    @Provides
    @Singleton
    @Named(value="fluxShardIdToShardPairMap")
    public Map<ShardId, ShardPairModel> getFluxRWShardIdToShardMapping(@Named(value="fluxMasterSlavePairList") List<ShardPairModel> masterSlavePairList) {
        HashMap<ShardId, ShardPairModel> shardIdToShardHostModelMap = new HashMap<ShardId, ShardPairModel>();
        masterSlavePairList.forEach(masterSlavePair -> shardIdToShardHostModelMap.put(masterSlavePair.getShardId(), (ShardPairModel)masterSlavePair));
        assert (masterSlavePairList.size() == shardIdToShardHostModelMap.size());
        return shardIdToShardHostModelMap;
    }

    @Provides
    @Singleton
    @Named(value="fluxShardKeyToShardIdMap")
    public Map<String, ShardId> getFluxRWShardKeyToShardIdMapping(@Named(value="fluxMasterSlavePairList") List<ShardPairModel> masterSlavePairList) {
        HashMap<String, ShardId> shardKeyToShardIdMap = new HashMap<String, ShardId>();
        masterSlavePairList.forEach(masterSlavePair -> {
            String startKey = masterSlavePair.getStartKey();
            String endKey = masterSlavePair.getEndKey();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    String shardPrefix = Integer.toHexString(i) + Integer.toHexString(j);
                    if (shardPrefix.compareTo(startKey) < 0 || shardPrefix.compareTo(endKey) > 0) continue;
                    assert (!shardKeyToShardIdMap.containsKey(shardPrefix));
                    shardKeyToShardIdMap.put(shardPrefix, masterSlavePair.getShardId());
                }
            }
        });
        this.checkShardConfig(shardKeyToShardIdMap, masterSlavePairList.size());
        if (shardKeyToShardIdMap.size() != 256) {
            throw new RuntimeException("No. of shardKeys should be 16*16, currently it is " + Integer.toString(shardKeyToShardIdMap.size()));
        }
        return shardKeyToShardIdMap;
    }

    public void checkShardConfig(Map<String, ShardId> shardKeyToShardIdMap, int noOfPhysicalShards) {
        HashMap shardKeysPerPhysicalShardCounter = new HashMap();
        shardKeyToShardIdMap.entrySet().forEach(entry -> {
            if (shardKeysPerPhysicalShardCounter.containsKey(entry.getValue())) {
                Integer currentCount = (Integer)shardKeysPerPhysicalShardCounter.get(entry.getValue());
                shardKeysPerPhysicalShardCounter.put(entry.getValue(), currentCount + 1);
            } else {
                shardKeysPerPhysicalShardCounter.put(entry.getValue(), 1);
            }
        });
        assert (shardKeysPerPhysicalShardCounter.size() == noOfPhysicalShards);
        shardKeysPerPhysicalShardCounter.entrySet().forEach(entry -> {
            assert ((Integer)entry.getValue() == 256 / noOfPhysicalShards);
        });
    }

    public org.hibernate.cfg.Configuration getRWConfiguration(YamlConfiguration yamlConfiguration, String host) {
        return this.getConfiguration(yamlConfiguration, FLUX_HIBERNATE_CONFIG_NAME_SPACE, host);
    }

    public org.hibernate.cfg.Configuration getROConfiguration(YamlConfiguration yamlConfiguration, String host) {
        return this.getConfiguration(yamlConfiguration, FLUX_READ_ONLY_HIBERNATE_CONFIG_NAME_SPACE, host);
    }

    @Provides
    @Singleton
    @Named(value="fluxROSessionFactoriesMap")
    public Map<ShardId, SessionFactory> getFluxROSessionFactoryMap(@Named(value="fluxShardIdToShardPairMap") Map<ShardId, ShardPairModel> fluxShardIdToShardPairMap, YamlConfiguration yamlConfiguration) {
        HashMap<ShardId, SessionFactory> fluxROSessionFactories = new HashMap<ShardId, SessionFactory>();
        fluxShardIdToShardPairMap.entrySet().forEach(shardKeyToShardIdMapping -> {
            ShardId shardId = (ShardId)shardKeyToShardIdMapping.getKey();
            ShardPairModel shardPairModel = (ShardPairModel)fluxShardIdToShardPairMap.get(shardId);
            org.hibernate.cfg.Configuration conf = this.getROConfiguration(yamlConfiguration, shardPairModel.getSlaveIp());
            if (!fluxROSessionFactories.containsKey(shardId)) {
                fluxROSessionFactories.put(shardId, conf.buildSessionFactory());
            }
        });
        if (fluxROSessionFactories.size() != fluxShardIdToShardPairMap.size()) {
            throw new RuntimeException("No. of RW Session Factories should be " + fluxShardIdToShardPairMap.size() + " currently it is " + Integer.toString(fluxROSessionFactories.size()));
        }
        return fluxROSessionFactories;
    }

    @Provides
    @Singleton
    @Named(value="fluxRWSessionFactoriesMap")
    public Map<ShardId, SessionFactory> getFluxRWSessionFactoryMap(@Named(value="fluxShardIdToShardPairMap") Map<ShardId, ShardPairModel> fluxShardIdToShardPairMap, YamlConfiguration yamlConfiguration) {
        HashMap<ShardId, SessionFactory> fluxRWSessionFactories = new HashMap<ShardId, SessionFactory>();
        fluxShardIdToShardPairMap.entrySet().forEach(shardKeyToShardIdMapping -> {
            ShardId shardId = (ShardId)shardKeyToShardIdMapping.getKey();
            ShardPairModel shardPairModel = (ShardPairModel)fluxShardIdToShardPairMap.get(shardId);
            org.hibernate.cfg.Configuration conf = this.getRWConfiguration(yamlConfiguration, shardPairModel.getMasterIp());
            if (!fluxRWSessionFactories.containsKey(shardId)) {
                fluxRWSessionFactories.putIfAbsent(shardId, conf.buildSessionFactory());
            }
        });
        if (fluxRWSessionFactories.size() != fluxShardIdToShardPairMap.size()) {
            throw new RuntimeException("No. of RW Session Factories should be " + fluxShardIdToShardPairMap.size() + ", currently it is " + Integer.toString(fluxRWSessionFactories.size()));
        }
        return fluxRWSessionFactories;
    }

    @Provides
    @Singleton
    @Named(value="fluxSessionFactoriesContext")
    public SessionFactoryContext getSessionFactoryProvider(@Named(value="fluxRWSessionFactoriesMap") Map<ShardId, SessionFactory> fluxRWSessionFactoriesMap, @Named(value="fluxROSessionFactoriesMap") Map<ShardId, SessionFactory> fluxROSessionFactoriesMap, @Named(value="fluxShardKeyToShardIdMap") Map<String, ShardId> shardKeyToShardIdMap, @Named(value="schedulerSessionFactory") SessionFactory schedulerSessionFactory) {
        return new SessionFactoryContextImpl(fluxRWSessionFactoriesMap, fluxROSessionFactoriesMap, shardKeyToShardIdMap, schedulerSessionFactory);
    }

    private void addAnnotatedClassesAndTypes(org.hibernate.cfg.Configuration configuration) {
        configuration.registerTypeOverride((UserType)new BlobType(), new String[]{"BlobType"});
        configuration.registerTypeOverride((UserType)new StoreFQNType(), new String[]{"StoreFQNOnly"});
        configuration.registerTypeOverride((UserType)new ListJsonType(Object.class), new String[]{"ListJsonType"});
        configuration.registerTypeOverride((UserType)new ListJsonType(Long.class), new String[]{"LongListJsonType"});
        configuration.addAnnotatedClass(AuditRecord.class);
        configuration.addAnnotatedClass(Event.class);
        configuration.addAnnotatedClass(State.class);
        configuration.addAnnotatedClass(StateMachine.class);
        configuration.addAnnotatedClass(ClientElb.class);
        configuration.addAnnotatedClass(StateTraversalPath.class);
    }

    private org.hibernate.cfg.Configuration getConfiguration(YamlConfiguration yamlConfiguration, String prefix, String host) {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        this.addAnnotatedClassesAndTypes(configuration);
        Configuration hibernateConfig = yamlConfiguration.subset(prefix);
        Iterator propertyKeys = hibernateConfig.getKeys();
        Properties configProperties = new Properties();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            Object propertyValue = hibernateConfig.getProperty(propertyKey);
            configProperties.put(propertyKey, propertyValue);
        }
        configProperties.setProperty("hibernate.connection.url", "jdbc:mysql://" + host + "/flux");
        configuration.addProperties(configProperties);
        return configuration;
    }
}

