/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.constant.RuntimeConstants;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Context;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.exception.CreateStateMachineException;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.persistence.StateMachineExecutionEntitiesManager;
import com.flipkart.flux.persistence.dao.iface.AuditDAO;
import com.flipkart.flux.persistence.dao.iface.AuditDAOV1;
import com.flipkart.flux.persistence.dao.iface.EventsDAOV1;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAOV1;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAOV1;
import com.flipkart.flux.persistence.key.FSMId;
import com.flipkart.flux.representation.EventPersistenceService;
import com.flipkart.flux.representation.StateMachinePersistenceService;
import com.flipkart.flux.runner.Modules;
import com.flipkart.flux.utils.SearchUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, FluxClientInterceptorModule.class})
public class StateMachinePersistenceServiceTest {
    @Mock
    StateMachinesDAO stateMachinesDAO;
    @Mock
    StateMachinesDAOV1 stateMachinesDAOV1;
    @Mock
    AuditDAO auditDAO;
    @Mock
    AuditDAOV1 auditDAOV1;
    @Mock
    StateTraversalPathDAO stateTraversalPathDAO;
    @Mock
    StateTraversalPathDAOV1 stateTraversalPathDAOV1;
    @Mock
    EventPersistenceService eventPersistenceService;
    @Mock
    EventsDAOV1 eventsDAOV1;
    @Mock
    ObjectMapper objectMapper;

    @Before
    public void setup() {
        this.objectMapper = new ObjectMapper();
    }

    @Test
    public void maxTaskRetryCountShouldBeTakenIfRetryCountIsHigher() throws Exception {
        Integer maxTaskRetryCount = 10;
        Mockito.when((Object)this.stateMachinesDAOV1.getPersistedEntityType()).thenReturn(StateMachine.class);
        Mockito.when((Object)this.auditDAOV1.getPersistedEntityType()).thenReturn(AuditRecord.class);
        StateMachineExecutionEntitiesManager smExecutionEntitiesManager = new StateMachineExecutionEntitiesManager(this.stateMachinesDAOV1, this.auditDAOV1, this.stateTraversalPathDAOV1, this.eventsDAOV1, maxTaskRetryCount, new SearchUtil());
        StateDefinition stateDefinition = new StateDefinition(Long.valueOf(1L), "state1", "desc", null, "task1", null, Long.valueOf(13L), Long.valueOf(1000L), Collections.emptyList(), null);
        StateMachineDefinition stateMachineDefinition = new StateMachineDefinition("desc", "state_machine_1", Long.valueOf(1L), Collections.singleton(stateDefinition), null, null, "client_elb_id_1");
        smExecutionEntitiesManager.createStateMachine(new FSMId("sample-state-machine-id"), stateMachineDefinition);
    }

    @Test
    public void retryCountShouldBeTakenIfItIsLessthanMaxAllowed() throws Exception {
        Integer maxTaskRetryCount = 10;
        Mockito.when((Object)this.stateMachinesDAOV1.getPersistedEntityType()).thenReturn(StateMachine.class);
        Mockito.when((Object)this.auditDAOV1.getPersistedEntityType()).thenReturn(AuditRecord.class);
        StateMachineExecutionEntitiesManager smExecutionEntitiesManager = new StateMachineExecutionEntitiesManager(this.stateMachinesDAOV1, this.auditDAOV1, this.stateTraversalPathDAOV1, this.eventsDAOV1, maxTaskRetryCount, new SearchUtil());
        StateDefinition stateDefinition = new StateDefinition(Long.valueOf(1L), "state1", "desc", null, "task1", null, Long.valueOf(3L), Long.valueOf(1000L), Collections.emptyList(), null);
        StateMachineDefinition stateMachineDefinition = new StateMachineDefinition("desc", "state_machine_1", Long.valueOf(1L), Collections.singleton(stateDefinition), null, null, "client_elb_id_1");
        smExecutionEntitiesManager.createStateMachine(new FSMId("sample-state-machine-id"), stateMachineDefinition);
    }

    @Test
    public void testConvertStateDefinitionToState() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_test.json"), (String)"UTF-8");
        Integer maxTaskRetryCount = 10;
        StateMachineDefinition stateMachineDefinition = (StateMachineDefinition)this.objectMapper.readValue(stateMachineDefinitionJson, StateMachineDefinition.class);
        Mockito.when((Object)this.stateMachinesDAOV1.getPersistedEntityType()).thenReturn(StateMachine.class);
        Mockito.when((Object)this.auditDAOV1.getPersistedEntityType()).thenReturn(AuditRecord.class);
        Mockito.when((Object)this.stateTraversalPathDAOV1.getPersistedEntityType()).thenReturn(StateTraversalPath.class);
        Mockito.when((Object)this.eventsDAOV1.getPersistedEntityType()).thenReturn(Event.class);
        StateMachineExecutionEntitiesManager smExecutionEntitiesManager = new StateMachineExecutionEntitiesManager(this.stateMachinesDAOV1, this.auditDAOV1, this.stateTraversalPathDAOV1, this.eventsDAOV1, maxTaskRetryCount, new SearchUtil());
        smExecutionEntitiesManager.createStateMachine(new FSMId(stateMachineDefinition.getCorrelationId()), stateMachineDefinition);
    }

    @Test
    public void testConvertStateDefinitionToStateWithReplayable() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_single_replayable_state.json"), (String)"UTF-8");
        Integer maxTaskRetryCount = 10;
        StateMachineDefinition stateMachineDefinition = (StateMachineDefinition)this.objectMapper.readValue(stateMachineDefinitionJson, StateMachineDefinition.class);
        Mockito.when((Object)this.stateMachinesDAOV1.getPersistedEntityType()).thenReturn(StateMachine.class);
        Mockito.when((Object)this.auditDAOV1.getPersistedEntityType()).thenReturn(AuditRecord.class);
        Mockito.when((Object)this.stateTraversalPathDAOV1.getPersistedEntityType()).thenReturn(StateTraversalPath.class);
        Mockito.when((Object)this.eventsDAOV1.getPersistedEntityType()).thenReturn(Event.class);
        StateMachineExecutionEntitiesManager smExecutionEntitiesManager = new StateMachineExecutionEntitiesManager(this.stateMachinesDAOV1, this.auditDAOV1, this.stateTraversalPathDAOV1, this.eventsDAOV1, maxTaskRetryCount, new SearchUtil());
        smExecutionEntitiesManager.createStateMachine(new FSMId(stateMachineDefinition.getCorrelationId()), stateMachineDefinition);
    }

    @Test
    public void testConvertStateDefinitionToStateWithReplayableRetriesGreaterThanThreshold() throws Exception {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_replayableRetries_greater_than_threshold.json"), (String)"UTF-8");
        Integer maxTaskRetryCount = 10;
        StateMachineDefinition stateMachineDefinition = (StateMachineDefinition)this.objectMapper.readValue(stateMachineDefinitionJson, StateMachineDefinition.class);
        Mockito.when((Object)this.stateMachinesDAOV1.getPersistedEntityType()).thenReturn(StateMachine.class);
        Mockito.when((Object)this.auditDAOV1.getPersistedEntityType()).thenReturn(AuditRecord.class);
        Mockito.when((Object)this.stateTraversalPathDAOV1.getPersistedEntityType()).thenReturn(StateTraversalPath.class);
        Mockito.when((Object)this.eventsDAOV1.getPersistedEntityType()).thenReturn(Event.class);
        StateMachineExecutionEntitiesManager smExecutionEntitiesManager = new StateMachineExecutionEntitiesManager(this.stateMachinesDAOV1, this.auditDAOV1, this.stateTraversalPathDAOV1, this.eventsDAOV1, maxTaskRetryCount, new SearchUtil());
        StateMachine stateMachine = smExecutionEntitiesManager.createStateMachine(new FSMId(stateMachineDefinition.getCorrelationId()), stateMachineDefinition);
        State replayableState = null;
        for (State state : stateMachine.getStates()) {
            if (!state.getReplayable().booleanValue()) continue;
            replayableState = state;
        }
        Assertions.assertThat((short)replayableState.getMaxReplayableRetries()).isEqualTo((Object)RuntimeConstants.MAX_REPLAYABLE_RETRIES);
    }

    private StateMachineDefinition createStateMachineDefinitionWithReplayableStates() {
        HashSet<StateDefinition> stateDefinitions = new HashSet<StateDefinition>();
        HashSet<EventData> eventData = new HashSet<EventData>();
        eventData.add(new EventData("e0", "java.lang.String", "dummy_data", "client"));
        Event e0_domain = new Event("e0", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(new EventDefinition("e0", "java.lang.String"))).thenReturn((Object)e0_domain);
        ArrayList<EventDefinition> t1_dependencies = new ArrayList<EventDefinition>();
        t1_dependencies.add(new EventDefinition("e0", "java.lang.String"));
        EventDefinition t1_OutputEvent = new EventDefinition("e1", "java.lang.String");
        eventData.add(new EventData("e1", "java.lang.String", null, "managed_runtime"));
        Event e1_domain = new Event("e1", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t1_OutputEvent)).thenReturn((Object)e1_domain);
        StateDefinition t1 = new StateDefinition(Long.valueOf(1L), "t1", "desc", null, "task1", null, Long.valueOf(3L), Long.valueOf(1000L), t1_dependencies, t1_OutputEvent, Boolean.TRUE.booleanValue());
        stateDefinitions.add(t1);
        ArrayList<EventDefinition> t2_dependencies = new ArrayList<EventDefinition>();
        t2_dependencies.add(new EventDefinition("e0", "java.lang.String"));
        EventDefinition t2_OutputEvent = new EventDefinition("e2", "java.lang.String");
        eventData.add(new EventData("e2", "java.lang.String", null, "managed_runtime"));
        Event e2_domain = new Event("e2", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t2_OutputEvent)).thenReturn((Object)e2_domain);
        StateDefinition t2 = new StateDefinition(Long.valueOf(1L), "t2", "desc", null, "task2", null, Long.valueOf(3L), Long.valueOf(1000L), t2_dependencies, t2_OutputEvent);
        stateDefinitions.add(t2);
        ArrayList<EventDefinition> t3_dependencies = new ArrayList<EventDefinition>();
        t3_dependencies.add(new EventDefinition("e1", "java.lang.String"));
        t3_dependencies.add(new EventDefinition("e2", "java.lang.String"));
        EventDefinition t3_OutputEvent = new EventDefinition("e3", "java.lang.String");
        eventData.add(new EventData("e3", "java.lang.String", null, "managed_runtime"));
        Event e3_domain = new Event("e3", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t3_OutputEvent)).thenReturn((Object)e3_domain);
        StateDefinition t3 = new StateDefinition(Long.valueOf(1L), "t3", "desc", null, "task3", null, Long.valueOf(3L), Long.valueOf(1000L), t3_dependencies, t3_OutputEvent);
        stateDefinitions.add(t3);
        ArrayList<EventDefinition> t4_dependencies = new ArrayList<EventDefinition>();
        t4_dependencies.add(new EventDefinition("e1", "java.lang.String"));
        t4_dependencies.add(new EventDefinition("e2", "java.lang.String"));
        EventDefinition t4_OutputEvent = new EventDefinition("e4", "java.lang.String");
        eventData.add(new EventData("e4", "java.lang.String", null, "managed_runtime"));
        Event e4_domain = new Event("e4", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t4_OutputEvent)).thenReturn((Object)e4_domain);
        StateDefinition t4 = new StateDefinition(Long.valueOf(1L), "t4", "desc", null, "task4", null, Long.valueOf(3L), Long.valueOf(1000L), t4_dependencies, t4_OutputEvent, Boolean.TRUE.booleanValue());
        stateDefinitions.add(t4);
        ArrayList<EventDefinition> t5_dependencies = new ArrayList<EventDefinition>();
        t5_dependencies.add(new EventDefinition("e3", "java.lang.String"));
        EventDefinition t5_OutputEvent = new EventDefinition("e5", "java.lang.String");
        eventData.add(new EventData("e5", "java.lang.String", null, "managed_runtime"));
        Event e5_domain = new Event("e5", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t5_OutputEvent)).thenReturn((Object)e5_domain);
        StateDefinition t5 = new StateDefinition(Long.valueOf(1L), "t5", "desc", null, "task5", null, Long.valueOf(3L), Long.valueOf(1000L), t5_dependencies, t5_OutputEvent);
        stateDefinitions.add(t5);
        ArrayList<EventDefinition> t6_dependencies = new ArrayList<EventDefinition>();
        t6_dependencies.add(new EventDefinition("e4", "java.lang.String"));
        t6_dependencies.add(new EventDefinition("e5", "java.lang.String"));
        t6_dependencies.add(new EventDefinition("e7", "java.lang.String"));
        EventDefinition t6_OutputEvent = new EventDefinition("e6", "java.lang.String");
        eventData.add(new EventData("e6", "java.lang.String", null, "managed_runtime"));
        Event e6_domain = new Event("e6", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t6_OutputEvent)).thenReturn((Object)e6_domain);
        StateDefinition t6 = new StateDefinition(Long.valueOf(1L), "t6", "desc", null, "task6", null, Long.valueOf(3L), Long.valueOf(1000L), t6_dependencies, t6_OutputEvent);
        stateDefinitions.add(t6);
        ArrayList<EventDefinition> t7_dependencies = new ArrayList<EventDefinition>();
        t7_dependencies.add(new EventDefinition("e4", "java.lang.String"));
        EventDefinition t7_OutputEvent = new EventDefinition("e7", "java.lang.String");
        eventData.add(new EventData("e7", "java.lang.String", null, "managed_runtime"));
        Event e7_domain = new Event("e7", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t7_OutputEvent)).thenReturn((Object)e7_domain);
        StateDefinition t7 = new StateDefinition(Long.valueOf(1L), "t7", "desc", null, "task7", null, Long.valueOf(3L), Long.valueOf(1000L), t7_dependencies, t7_OutputEvent);
        stateDefinitions.add(t7);
        ArrayList<EventDefinition> t8_dependencies = new ArrayList<EventDefinition>();
        t8_dependencies.add(new EventDefinition("e4", "java.lang.String"));
        EventDefinition t8_OutputEvent = new EventDefinition("e8", "java.lang.String");
        eventData.add(new EventData("e8", "java.lang.String", null, "managed_runtime"));
        Event e8_domain = new Event("e8", "java.lang.String", Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
        Mockito.when((Object)this.eventPersistenceService.convertEventDefinitionToEvent(t8_OutputEvent)).thenReturn((Object)e8_domain);
        StateDefinition t8 = new StateDefinition(Long.valueOf(1L), "t8", "desc", null, "task8", null, Long.valueOf(3L), Long.valueOf(1000L), t8_dependencies, t8_OutputEvent, Boolean.TRUE.booleanValue());
        stateDefinitions.add(t8);
        ArrayList<EventDefinition> t9_dependencies = new ArrayList<EventDefinition>();
        t9_dependencies.add(new EventDefinition("e8", "java.lang.String"));
        StateDefinition t9 = new StateDefinition(Long.valueOf(1L), "t9", "desc", null, "task9", null, Long.valueOf(3L), Long.valueOf(1000L), t9_dependencies, null, Boolean.TRUE.booleanValue());
        stateDefinitions.add(t9);
        StateMachineDefinition stateMachineDefinition = new StateMachineDefinition("desc", "state_machine_2", Long.valueOf(1L), stateDefinitions, eventData, null, "client_elb_id_1");
        return stateMachineDefinition;
    }

    @Test
    public void verifyReplayStateTraversalPath() throws Exception {
        Integer maxTaskRetryCount = 10;
        StateMachinePersistenceService stateMachinePersistenceService = new StateMachinePersistenceService(this.stateMachinesDAO, this.auditDAO, this.stateTraversalPathDAO, this.eventPersistenceService, maxTaskRetryCount);
        Mockito.when((Object)this.stateMachinesDAOV1.getPersistedEntityType()).thenReturn(StateMachine.class);
        Mockito.when((Object)this.auditDAOV1.getPersistedEntityType()).thenReturn(AuditRecord.class);
        Mockito.when((Object)this.stateTraversalPathDAOV1.getPersistedEntityType()).thenReturn(StateTraversalPath.class);
        Mockito.when((Object)this.eventsDAOV1.getPersistedEntityType()).thenReturn(Event.class);
        StateMachineExecutionEntitiesManager smExecutionEntitiesManager = new StateMachineExecutionEntitiesManager(this.stateMachinesDAOV1, this.auditDAOV1, this.stateTraversalPathDAOV1, this.eventsDAOV1, maxTaskRetryCount, new SearchUtil());
        StateMachineDefinition stateMachineDefinition = this.createStateMachineDefinitionWithReplayableStates();
        StateMachine stateMachine = smExecutionEntitiesManager.createStateMachine(new FSMId("sample-state-machine-id-2"), stateMachineDefinition);
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        Map replayStateTraversalPath = stateMachinePersistenceService.createAndPersistStateTraversal("sample-state-machine-id-2", stateMachine, (Context)context);
        Assertions.assertThat((int)replayStateTraversalPath.size()).isEqualTo(4);
        Assertions.assertThat((boolean)replayStateTraversalPath.isEmpty()).isFalse();
        for (State state : stateMachine.getStates()) {
            if (!state.getReplayable().booleanValue()) continue;
            Assertions.assertThat((Map)replayStateTraversalPath).containsKey((Object)state.getId());
            switch (state.getName()) {
                case "t1": {
                    Assertions.assertThat((int)((List)replayStateTraversalPath.get(state.getId())).size()).isEqualTo(8);
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains(state.getName()));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t3"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t4"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t5"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t6"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t7"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t8"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t9"));
                    break;
                }
                case "t4": {
                    Assertions.assertThat((int)((List)replayStateTraversalPath.get(state.getId())).size()).isEqualTo(5);
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains(state.getName()));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t6"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t7"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t8"));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t9"));
                    break;
                }
                case "t8": {
                    Assertions.assertThat((int)((List)replayStateTraversalPath.get(state.getId())).size()).isEqualTo(2);
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains(state.getName()));
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains("t9"));
                    break;
                }
                case "t9": {
                    Assertions.assertThat((int)((List)replayStateTraversalPath.get(state.getId())).size()).isEqualTo(1);
                    Assertions.assertThat((boolean)((List)replayStateTraversalPath.get(state.getId())).contains(state.getName()));
                }
            }
        }
    }

    @Test(expected=CreateStateMachineException.class)
    public void testValidateMultipleStatesWithSameReplayEvent() throws IOException, CreateStateMachineException {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_5.json"), (String)"UTF-8");
        StateMachineDefinition stateMachineDefinition = (StateMachineDefinition)this.objectMapper.readValue(stateMachineDefinitionJson, StateMachineDefinition.class);
        StateMachineDefinition stateMachineDefinition1 = StateMachinePersistenceService.validateReplayableStates((StateMachineDefinition)stateMachineDefinition);
        Set states = stateMachineDefinition1.getStates();
        states.forEach(state -> {
            if (state.getName().equals("test_state2") || state.getName().equals("test_state3")) {
                Assertions.assertThat((boolean)state.isReplayable()).isEqualTo(false);
            }
        });
    }

    @Test(expected=CreateStateMachineException.class)
    public void testValidateStateWithMultipleReplayEvent() throws IOException, CreateStateMachineException {
        String stateMachineDefinitionJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("state_machine_definition_4.json"), (String)"UTF-8");
        StateMachineDefinition stateMachineDefinition = (StateMachineDefinition)this.objectMapper.readValue(stateMachineDefinitionJson, StateMachineDefinition.class);
        StateMachineDefinition stateMachineDefinition1 = StateMachinePersistenceService.validateReplayableStates((StateMachineDefinition)stateMachineDefinition);
        Set states = stateMachineDefinition1.getStates();
        states.forEach(state -> {
            if (state.getName().equals("test_state2")) {
                Assertions.assertThat((boolean)state.isReplayable()).isEqualTo(false);
            }
        });
    }
}

