/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.constant.RuntimeConstants;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.persistence.dao.iface.AuditDAO;
import com.flipkart.flux.persistence.dao.iface.EventsDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.representation.ReplayEventPersistenceService;
import com.flipkart.flux.rule.DbClearWithTestSMRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, FluxClientInterceptorModule.class})
public class ReplayEventPersistenceServiceTest {
    private static ObjectMapper objectMapper;
    @InjectFromRole
    @Rule
    public DbClearWithTestSMRule dbClearWithTestSMRule;
    @InjectFromRole
    StateMachinesDAO stateMachinesDAO;
    @InjectFromRole
    EventsDAO eventsDAO;
    @InjectFromRole
    StatesDAO statesDAO;
    @InjectFromRole
    AuditDAO auditDAO;
    @InjectFromRole
    ReplayEventPersistenceService replayEventPersistenceService;

    @Before
    public void setup() {
        objectMapper = new ObjectMapper();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testReplayEventPersistenceAndExecutionVersionUpdate() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachineWithMultipleReplayableStates();
        EventData replayEventData1 = new EventData("re1", "replayEvent", "re1_EventData", "flux_runtime_replay_internal", Boolean.FALSE);
        ArrayList<Long> dependentStateIds_1 = new ArrayList<Long>();
        dependentStateIds_1.add(2L);
        dependentStateIds_1.add(4L);
        dependentStateIds_1.add(5L);
        ArrayList<String> dependentEvents_1 = new ArrayList<String>();
        dependentEvents_1.add(objectMapper.writeValueAsString((Object)new EventDefinition("e2", "dummyType")));
        dependentEvents_1.add(objectMapper.writeValueAsString((Object)new EventDefinition("e4", "dummyType")));
        String onEntryHook = "com.flipkart.flux.dao.DummyOnEntryHook";
        String task = "com.flipkart.flux.dao.TestWorkflow_dummyTask";
        String onExitHook = "com.flipkart.flux.dao.DummyOnExitHook";
        ArrayList<String> deps_t2 = new ArrayList<String>();
        deps_t2.add("e1");
        deps_t2.add("re1");
        String oe2 = objectMapper.writeValueAsString((Object)new EventDefinition("e2", "dummyType"));
        State t2 = new State(Long.valueOf(2L), "t2", "desc2", onEntryHook, task, onExitHook, deps_t2, Long.valueOf(3L), Long.valueOf(60L), oe2, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(2L), RuntimeConstants.MAX_REPLAYABLE_RETRIES, Short.valueOf((short)0), Boolean.TRUE, Long.valueOf(0L));
        Event replayEvent1 = this.replayEventPersistenceService.persistAndProcessReplayEvent(stateMachine.getId(), replayEventData1, dependentStateIds_1, dependentEvents_1, t2);
        Assertions.assertThat((Comparable)replayEvent1.getStatus()).isEqualTo((Object)Event.EventStatus.triggered);
        Assertions.assertThat((String)replayEvent1.getEventSource()).contains(new CharSequence[]{"flux_runtime_replay_internal"});
        Assertions.assertThat((Long)replayEvent1.getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.stateMachinesDAO.findById(stateMachine.getId()).getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L)).getExecutionVersion()).isNotEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(2L)).getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(3L)).getExecutionVersion()).isNotEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(4L)).getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(5L)).getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(6L)).getExecutionVersion()).isNotEqualTo(1L);
        Assertions.assertThat((int)this.eventsDAO.findBySMInstanceId(stateMachine.getId()).size()).isEqualTo(7);
        Assertions.assertThat((int)this.eventsDAO.findAllBySMIdAndName(stateMachine.getId(), "re1").size()).isEqualTo(2);
        Assertions.assertThat((int)this.eventsDAO.findAllBySMIdAndName(stateMachine.getId(), "e2").size()).isEqualTo(2);
        Assertions.assertThat((int)this.eventsDAO.findAllBySMIdAndName(stateMachine.getId(), "e4").size()).isEqualTo(2);
        EventData replayEventData2 = new EventData("re2", "replayEvent", "re2_EventData", "flux_runtime_replay_internal", Boolean.FALSE);
        ArrayList<Long> dependentStateIds_2 = new ArrayList<Long>();
        dependentStateIds_2.add(3L);
        dependentStateIds_2.add(5L);
        dependentStateIds_2.add(6L);
        ArrayList<String> dependentEvents_2 = new ArrayList<String>();
        dependentEvents_2.add(objectMapper.writeValueAsString((Object)new EventDefinition("e3", "dummyType")));
        ArrayList<String> deps_t3 = new ArrayList<String>();
        deps_t3.add("e1");
        deps_t3.add("re2");
        String oe3 = objectMapper.writeValueAsString((Object)new EventDefinition("e3", "dummyType"));
        State t3 = new State(Long.valueOf(2L), "t3", "desc2", onEntryHook, task, onExitHook, deps_t3, Long.valueOf(3L), Long.valueOf(60L), oe3, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(3L), RuntimeConstants.MAX_REPLAYABLE_RETRIES, Short.valueOf((short)0), Boolean.TRUE, Long.valueOf(0L));
        Event replayEvent2 = this.replayEventPersistenceService.persistAndProcessReplayEvent(stateMachine.getId(), replayEventData2, dependentStateIds_2, dependentEvents_2, t3);
        Assertions.assertThat((Comparable)replayEvent2.getStatus()).isEqualTo((Object)Event.EventStatus.triggered);
        Assertions.assertThat((String)replayEvent2.getEventSource()).contains(new CharSequence[]{"flux_runtime_replay_internal"});
        Assertions.assertThat((Long)replayEvent2.getExecutionVersion()).isEqualTo(2L);
        Assertions.assertThat((Long)this.stateMachinesDAO.findById(stateMachine.getId()).getExecutionVersion()).isEqualTo(2L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(1L)).getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(2L)).getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(3L)).getExecutionVersion()).isEqualTo(2L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(4L)).getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(5L)).getExecutionVersion()).isEqualTo(2L);
        Assertions.assertThat((Long)this.statesDAO.findById(stateMachine.getId(), Long.valueOf(6L)).getExecutionVersion()).isEqualTo(2L);
        Assertions.assertThat((int)this.eventsDAO.findBySMInstanceId(stateMachine.getId()).size()).isEqualTo(7);
        Assertions.assertThat((int)this.eventsDAO.findAllBySMIdAndName(stateMachine.getId(), "re2").size()).isEqualTo(2);
        Assertions.assertThat((int)this.eventsDAO.findAllBySMIdAndName(stateMachine.getId(), "e3").size()).isEqualTo(2);
    }

    @Test
    public void testConcurrentStateMachineExecutionVersionUpdate() throws Exception {
    }
}

